/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.AdminEmfStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.ShareProjectAdapter;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGroupImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESAuthorizationService;
import org.eclipse.emf.emfstore.server.auth.ESProjectAdminPrivileges;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.ESGroup;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminEmfStoreImpl
extends AbstractEmfstoreInterface
implements AdminEmfStore {
    public AdminEmfStoreImpl(ServerSpace serverSpace, AccessControl accessControl) throws FatalESException {
        super(serverSpace, accessControl);
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.checkProjectAdminAccess(sessionId);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        for (ACGroup group : this.getGroups()) {
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    private List<ACGroup> getGroups() {
        ArrayList<ACGroup> groups = new ArrayList<ACGroup>();
        for (ESGroup group : this.getAccessControl().getOrgUnitProviderService().getGroups()) {
            groups.add((ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(group)).toInternalAPI());
        }
        return groups;
    }

    private List<ACUser> getUsers() {
        ArrayList<ACUser> users = new ArrayList<ACUser>();
        for (ESUser user : this.getAccessControl().getOrgUnitProviderService().getUsers()) {
            users.add((ACUser)((ESUserImpl)ESUserImpl.class.cast(user)).toInternalAPI());
        }
        return users;
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, orgUnitId);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        ACOrgUnit<?> orgUnit = this.getOrgUnit(orgUnitId);
        for (ACGroup group : this.getGroups()) {
            if (!group.getMembers().contains(orgUnit)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    @Override
    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        this.checkForNulls(sessionId, name);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.CreateGroup);
        if (this.groupExists(name)) {
            throw new InvalidInputException(Messages.AdminEmfStoreImpl_Group_Already_Exists);
        }
        ACGroup acGroup = AccesscontrolFactory.eINSTANCE.createACGroup();
        acGroup.setName(name);
        acGroup.setDescription("");
        this.getAccessControl().getOrgUnitProviderService().addGroup((ESGroup)acGroup.toAPI());
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acGroup.getId());
    }

    private boolean groupExists(String name) {
        for (ACGroup group : this.getGroups()) {
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        this.checkForNulls(sessionId, user, group);
        boolean isServerAdmin = this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.DeleteOrgUnit);
        if (!isServerAdmin) {
            this.getAccessControl().getAuthorizationService().checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)group.toAPI());
        }
        this.getGroup(group).getMembers().remove(this.getOrgUnit(user));
        this.save();
    }

    @Override
    public void deleteGroup(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.checkForNulls(sessionId, groupId);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        authorizationService.checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.DeleteOrgUnit);
        authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)groupId.toAPI());
        ACGroup group = this.getGroup(groupId);
        for (ACOrgUnit member : group.getMembers()) {
            authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)member.getId().toAPI());
        }
        for (ACGroup nextGroup : this.getGroups()) {
            List<ACGroup> groups = this.getGroups(sessionId, groupId);
            if (!nextGroup.getId().equals(groupId)) continue;
            for (ACGroup acGroup : groups) {
                this.removeMember(sessionId, acGroup.getId(), nextGroup.getId());
            }
            this.getAccessControl().getOrgUnitProviderService().removeGroup((ESGroup)nextGroup.toAPI());
            EcoreUtil.delete((EObject)nextGroup);
            this.save();
            return;
        }
    }

    @Override
    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.checkForNulls(sessionId, groupId);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit orgUnit : this.getGroup(groupId).getMembers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addMember(SessionId sessionId, ACOrgUnitId groupId, ACOrgUnitId member) throws ESException {
        this.checkForNulls(sessionId, groupId, member);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        boolean isServerAdmin = authorizationService.checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.ChangeAssignmentsOfOrgUnits);
        if (!isServerAdmin) {
            authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)groupId.toAPI());
        }
        this.addToGroup(groupId, member);
    }

    private void addToGroup(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit<?> acMember = this.getOrgUnit(member);
        acGroup.getMembers().add(acMember);
        this.save();
    }

    @Override
    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        this.checkForNulls(sessionId, group, member);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        boolean isServerAdmin = authorizationService.checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.ChangeAssignmentsOfOrgUnits);
        if (!isServerAdmin) {
            authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)group.toAPI());
        }
        this.removeFromGroup(group, member);
    }

    private void removeFromGroup(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit<?> acMember = this.getOrgUnit(member);
        if (acGroup.getMembers().contains(acMember)) {
            acGroup.getMembers().remove(acMember);
            this.save();
        }
    }

    @Override
    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        EList roles;
        this.checkForNulls(sessionId);
        this.checkProjectAdminAccess(sessionId, projectId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit aCOrgUnit : this.getUsers()) {
            roles = aCOrgUnit.getRoles();
            for (Role role : roles) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)aCOrgUnit));
            }
        }
        for (ACOrgUnit aCOrgUnit : this.getGroups()) {
            roles = aCOrgUnit.getRoles();
            for (Role role : roles) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)aCOrgUnit));
            }
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId, roleClass);
        boolean isServerAdmin = this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI(), ESProjectAdminPrivileges.AssignRoleToOrgUnit);
        if (!isServerAdmin && roleClass.equals(RolesPackage.eINSTANCE.getServerAdmin())) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Not_Allowed_To_Create_Participant_With_ServerAdminRole);
        }
        projectId = this.getProjectId(projectId);
        ACOrgUnit<?> orgUnit = this.getOrgUnit(participantId);
        EList roles = orgUnit.getRoles();
        for (Role role : roles) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            return;
        }
        EList roles2 = orgUnit.getRoles();
        for (Role role : roles2) {
            if (!this.areEqual(role, roleClass)) continue;
            role.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        Role newRole = this.createRoleFromEClass(roleClass);
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public void addInitialParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId, roleClass);
        this.checkSession(sessionId);
        if (this.isServerAdminRole(roleClass)) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Not_Allowed_To_Assign_ServerAdminRole);
        }
        SessionId session = this.resolveSessionById(sessionId.getId());
        ACUser resolvedUser = this.resolveUserBySessionId(session.getId());
        if (!resolvedUser.getId().equals(participantId)) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_OnlyAllowedForRequstingUser);
        }
        this.checkProjectAdminAccess(session, ESProjectAdminPrivileges.ShareProject);
        AdminEmfStoreImpl.checkIfSessionIsAssociatedWithProject(session, projectId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit<?> orgUnit = this.getOrgUnit(participantId);
        for (Role role : orgUnit.getRoles()) {
            if (!this.areEqual(role, roleClass)) continue;
            role.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
    }

    private static void checkIfSessionIsAssociatedWithProject(SessionId sessionId, ProjectId projectId) throws AccessControlException {
        EList eAdapters = sessionId.eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!ShareProjectAdapter.class.isInstance(adapter)) continue;
            ShareProjectAdapter shareAdapter = (ShareProjectAdapter)adapter;
            boolean didRemove = shareAdapter.removeProject(projectId);
            if (didRemove) {
                return;
            }
            throw new AccessControlException(Messages.AdminEmfStoreImpl_IllegalRequestToAddInitialRole);
        }
        throw new AccessControlException(Messages.AdminEmfStoreImpl_IllegalRequestToAddInitialRole);
    }

    private Role createRoleFromEClass(EClass roleClass) {
        return (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
    }

    private ProjectId getProjectId(ProjectId projectId) throws ESException {
        for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
            if (!projectHistory.getProjectId().equals(projectId)) continue;
            return projectHistory.getProjectId();
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Unknown_ProjectID);
    }

    @Override
    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId);
        boolean isServerAdmin = this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI(), ESProjectAdminPrivileges.AssignRoleToOrgUnit);
        ACOrgUnit<?> orgUnit = this.getOrgUnit(participantId);
        projectId = this.getProjectId(projectId);
        EList roles = orgUnit.getRoles();
        for (Role role : roles) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            if (!isServerAdmin && role.canAdministrate(projectId)) {
                throw new AccessControlException(String.valueOf(Messages.AdminEmfStoreImpl_RemovePA_Violation_1) + Messages.AdminEmfStoreImpl_RemovePA_Violation_2);
            }
            role.getProjects().remove((Object)projectId);
            this.save();
            return;
        }
    }

    @Override
    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, projectId, orgUnitId);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI());
        projectId = this.getProjectId(projectId);
        ACOrgUnit<?> oUnit = this.getOrgUnit(orgUnitId);
        EList roles = oUnit.getRoles();
        for (Role role : roles) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Could_Not_Find_OrgUnit);
    }

    @Override
    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        ACOrgUnit<?> orgUnit;
        this.checkForNulls(sessionId, projectId, orgUnitId, roleClass);
        this.checkSession(sessionId);
        SessionId session = this.resolveSessionById(sessionId.getId());
        this.checkProjectAdminAccess(session, projectId, ESProjectAdminPrivileges.AssignRoleToOrgUnit);
        boolean isServerAdmin = this.checkProjectAdminAccessForOrgUnit(session, projectId, orgUnitId);
        if (!isServerAdmin && this.isServerAdminRole(roleClass)) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Not_Allowed_To_Assign_ServerAdminRole);
        }
        ProjectId resolvedProjectId = this.getProjectId(projectId);
        Role role = this.getRole(resolvedProjectId, orgUnit = this.getOrgUnit(orgUnitId));
        if (role != null) {
            if (!isServerAdmin && role.canAdministrate(resolvedProjectId)) {
                throw new AccessControlException(String.valueOf(Messages.AdminEmfStoreImpl_RemovePA_Violation_1) + Messages.AdminEmfStoreImpl_RemovePA_Violation_2);
            }
            role.getProjects().remove((Object)resolvedProjectId);
            if (role.getProjects().isEmpty()) {
                orgUnit.getRoles().remove((Object)role);
            }
        }
        if (this.isServerAdminRole(roleClass)) {
            orgUnit.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
            this.save();
            return;
        }
        EList roles = orgUnit.getRoles();
        for (Role r : roles) {
            if (!r.eClass().getName().equals(roleClass.getName())) continue;
            r.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)resolvedProjectId)));
            this.save();
            return;
        }
        Role newRole = this.createRoleFromEClass(roleClass);
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)resolvedProjectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public void assignRole(SessionId sessionId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, orgUnitId, roleClass);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        authorizationService.checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.AssignRoleToOrgUnit);
        boolean isServerAdmin = authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)orgUnitId.toAPI());
        if (!isServerAdmin && this.isServerAdminRole(roleClass)) {
            throw new AccessControlException("A project admin is not allowed to assign a server admin role");
        }
        ACOrgUnit<?> orgUnit = this.getOrgUnit(orgUnitId);
        EList roles = orgUnit.getRoles();
        for (Role role : roles) {
            if (!this.areEqual(role, roleClass)) continue;
            return;
        }
        Role newRole = this.createRoleFromEClass(roleClass);
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null);
        ArrayList<ACUser> result = new ArrayList<ACUser>();
        for (ACUser user : this.getUsers()) {
            result.add(user);
        }
        return result;
    }

    @Override
    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.checkSession(sessionId);
        this.checkProjectAdminAccess(sessionId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit aCOrgUnit : this.getUsers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)aCOrgUnit));
        }
        for (ACOrgUnit aCOrgUnit : this.getGroups()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)aCOrgUnit));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
        for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
            try {
                this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectHistory.getProjectId().toAPI());
                result.add(this.getProjectInfo(projectHistory));
            }
            catch (AccessControlException accessControlException) {}
        }
        return result;
    }

    @Override
    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        this.checkForNulls(sessionId, name);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.CreateUser);
        if (this.userExists(name)) {
            throw new InvalidInputException("Username '" + name + "' already exists.");
        }
        ACUser acUser = AccesscontrolFactory.eINSTANCE.createACUser();
        acUser.setName(name);
        acUser.setDescription("");
        this.getAccessControl().getOrgUnitProviderService().addUser((ESUser)acUser.toAPI());
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acUser.getId());
    }

    private boolean userExists(String name) {
        for (ACUser user : this.getUsers()) {
            if (!user.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteUser(SessionId sessionId, ACOrgUnitId userId) throws ESException {
        this.checkForNulls(sessionId, userId);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)userId.toAPI());
        authorizationService.checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, ESProjectAdminPrivileges.DeleteOrgUnit);
        for (ACUser user : this.getUsers()) {
            List<ACGroup> groups = this.getGroups(sessionId, userId);
            if (!user.getId().equals(userId)) continue;
            for (ACGroup acGroup : groups) {
                this.removeMember(sessionId, acGroup.getId(), userId);
            }
            this.getAccessControl().getOrgUnitProviderService().removeUser((ESUser)user.toAPI());
            EcoreUtil.delete((EObject)user);
            this.save();
            return;
        }
    }

    @Override
    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        this.checkForNulls(sessionId, orgUnitId, name, description);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)orgUnitId.toAPI());
        ACOrgUnit<?> orgUnit = this.getOrgUnit(orgUnitId);
        orgUnit.setName(name);
        orgUnit.setDescription(description);
        this.save();
    }

    @Override
    public void changeUser(SessionId sessionId, ACOrgUnitId userId, String name, String password) throws ESException {
        this.checkForNulls(sessionId, userId, name, password);
        this.checkSession(sessionId);
        ESAuthorizationService authorizationService = this.getAccessControl().getAuthorizationService();
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        ACOrgUnit<?> orgUnit = this.getOrgUnit(userId);
        ACUser requestingUser = this.resolveUserBySessionId(sessionId.getId());
        if (orgUnit.equals((Object)requestingUser)) {
            this.updateUser(userId, name, password);
            return;
        }
        boolean isServerAdmin = this.checkProjectAdminAccess(session, ESProjectAdminPrivileges.ChangeUserPassword);
        if (!isServerAdmin) {
            authorizationService.checkProjectAdminAccessForOrgUnit((ESSessionId)session.toAPI(), (ESOrgUnitId)userId.toAPI());
        }
        this.updateUser(userId, name, password);
    }

    private void updateUser(ACOrgUnitId userId, String name, String password) throws ESException {
        ACUser user = (ACUser)this.getOrgUnit(userId);
        user.setName(name);
        user.setPassword(password);
        this.save();
    }

    public ACOrgUnit<?> getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, orgUnitId);
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null);
        ACOrgUnit orgUnit = (ACOrgUnit)ModelUtil.clone(this.getOrgUnit(orgUnitId));
        this.clearMembersFromGroup(orgUnit);
        return orgUnit;
    }

    private void clearMembersFromGroups(Collection<ACOrgUnit> orgUnits) {
        for (ACOrgUnit orgUnit : orgUnits) {
            this.clearMembersFromGroup(orgUnit);
        }
    }

    private void clearMembersFromGroup(ACOrgUnit orgUnit) {
        if (orgUnit instanceof ACGroup) {
            ((ACGroup)orgUnit).getMembers().clear();
        }
    }

    private boolean isServerAdmin(Role role) {
        return role.eClass().getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName());
    }

    private boolean isServerAdminRole(EClass role) {
        return role.getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName());
    }

    private boolean areEqual(Role role, EClass roleClass) {
        return role.eClass().getName().equals(roleClass.getName());
    }

    private ProjectInfo getProjectInfo(ProjectHistory project) {
        ProjectInfo info = ModelFactory.eINSTANCE.createProjectInfo();
        info.setName(project.getProjectName());
        info.setDescription(project.getProjectDescription());
        info.setProjectId((ProjectId)ModelUtil.clone((EObject)project.getProjectId()));
        info.setVersion(project.getLastVersion().getPrimarySpec());
        return info;
    }

    private ACGroup getGroup(ACOrgUnitId orgUnitId) throws ESException {
        for (ACGroup group : this.getGroups()) {
            if (!group.getId().equals(orgUnitId)) continue;
            return group;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Group_Does_Not_Exist);
    }

    private ACOrgUnit<?> getOrgUnit(ACOrgUnitId orgUnitId) throws ESException {
        for (ACOrgUnit aCOrgUnit : this.getUsers()) {
            if (!aCOrgUnit.getId().equals(orgUnitId)) continue;
            return aCOrgUnit;
        }
        for (ACOrgUnit aCOrgUnit : this.getGroups()) {
            if (!aCOrgUnit.getId().equals(orgUnitId)) continue;
            return aCOrgUnit;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_OrgUnit_Does_Not_Exist);
    }

    private Role getRole(ProjectId projectId, ACOrgUnit<?> orgUnit) {
        EList roles = orgUnit.getRoles();
        for (Role role : roles) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        return null;
    }

    private void save() throws ESException {
        try {
            this.getAccessControl().getOrgUnitProviderService().save();
        }
        catch (IOException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
        catch (NullPointerException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
    }

    private void checkForNulls(Object ... objects) throws InvalidInputException {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                throw new InvalidInputException();
            }
            ++n2;
        }
    }

    @Override
    protected void initSubInterfaces() throws FatalESException {
    }
}

