/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.CreateOrgUnitAction;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.Messages;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.viewers.TableViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateUserAction
extends CreateOrgUnitAction {
    private static final String USER_FIELD_NAME = Messages.CreateUserAction_UserName_Field;
    private static final String PW_FIELD_NAME = Messages.CreateUserAction_Password_Field;
    private Boolean passwordControlsEnabled;

    public CreateUserAction(AdminBroker adminBroker, TableViewer tableViewer, PropertiesForm form) {
        super(Messages.CreateUserAction_ActionTitle, adminBroker, tableViewer, form);
    }

    @Override
    protected Set<String> getInputFieldNames() {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        fieldNames.add(USER_FIELD_NAME);
        if (this.passwordControlsEnabled()) {
            fieldNames.add(PW_FIELD_NAME);
        }
        return fieldNames;
    }

    @Override
    protected String getPrimaryFieldName() {
        return USER_FIELD_NAME;
    }

    @Override
    protected String orgUnitName() {
        return Messages.CreateUserAction_OrgUnitName;
    }

    @Override
    protected ACOrgUnitId createOrgUnit(Map<String, String> fieldValues) throws ESException {
        String userName = fieldValues.get(USER_FIELD_NAME);
        String pwd = fieldValues.get(PW_FIELD_NAME);
        if (StringUtils.isBlank((String)userName)) {
            throw new ESException(Messages.CreateUserAction_UserName_Empty);
        }
        if (this.passwordControlsEnabled() && StringUtils.isBlank((String)pwd)) {
            throw new ESException(Messages.CreateUserAction_Password_Empty);
        }
        ACOrgUnitId userId = this.getAdminBroker().createUser(userName);
        if (this.passwordControlsEnabled()) {
            this.getAdminBroker().changeUser(userId, userName, pwd);
        }
        return userId;
    }

    private boolean passwordControlsEnabled() {
        if (this.passwordControlsEnabled == null) {
            ESExtensionPoint showPasswordControls = new ESExtensionPoint("org.eclipse.emf.emfstore.client.ui.showPasswordControls");
            this.passwordControlsEnabled = showPasswordControls.getBoolean("enabled", false);
        }
        return this.passwordControlsEnabled;
    }
}

