/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.internal.junit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.junit.FrameworkFields;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.junit.Messages;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.Annotations;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESDefaultModelMutator;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyTest;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyUtil;
import org.eclipse.emf.emfstore.modelmutator.ESAbstractModelMutator;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyTestClassRunner
extends BlockJUnit4ClassRunner {
    private final int counter;
    private final ESFuzzyDataProvider<?> dataProvider;
    private final FrameworkField dataField;
    private final FrameworkField utilField;
    private final ESFuzzyUtil util;
    private final FrameworkField optionsField;
    private final FrameworkField mutatorField;

    public FuzzyTestClassRunner(Class<?> type, ESFuzzyDataProvider<?> dataProvider, FrameworkFields frameworkFields, ESFuzzyUtil util, int counter) throws InitializationError {
        super(type);
        this.mutatorField = frameworkFields.getMutatorField();
        this.dataField = frameworkFields.getDataField();
        this.utilField = frameworkFields.getUtilField();
        this.optionsField = frameworkFields.getOptionsField();
        this.counter = counter;
        this.util = util;
        this.dataProvider = dataProvider;
    }

    public Object createTest() {
        try {
            ESDefaultModelMutator modelMutator;
            Object testInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
            if (this.optionsField != null) {
                Object options = this.getValueFromField(this.optionsField.getField(), testInstance);
                if (options == null) {
                    throw new IllegalStateException(Messages.getString("FuzzyTestClassRunner.OptionsFieldIsNull"));
                }
                try {
                    this.dataProvider.setOptions((Map)options);
                }
                catch (ClassCastException classCastException) {
                    throw new ClassCastException(Messages.getString("FuzzyTestClassRunner.OptionsFieldWrongType"));
                }
            }
            ESModelMutatorConfiguration config = this.dataProvider.getModelMutatorConfiguration();
            if (this.mutatorField != null) {
                modelMutator = (ESAbstractModelMutator)this.mutatorField.getType().newInstance();
                modelMutator.setConfig(config);
                this.setValueToField(this.mutatorField.getField(), testInstance, (Object)modelMutator, Messages.getString("FuzzyTestClassRunner.MutatorFieldSetFailed"));
            } else {
                modelMutator = new ESDefaultModelMutator(config);
            }
            this.dataProvider.setMutator(modelMutator);
            Object data = this.dataProvider.get(this.counter);
            this.setValueToField(this.dataField.getField(), testInstance, data, MessageFormat.format(Messages.getString("FuzzyTestClassRunner.DataProviderTypeError"), Annotations.Data.class.getSimpleName(), this.dataProvider.getClass()));
            if (this.util != null && this.utilField != null) {
                this.setValueToField(this.utilField.getField(), testInstance, this.util, MessageFormat.format(Messages.getString("FuzzyTestClassRunner.UtilTypeError"), ESFuzzyUtil.class.getSimpleName()));
            }
            return testInstance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getValueFromField(Field field, Object instance) throws IllegalAccessException {
        try {
            Object o;
            field.setAccessible(true);
            Object object = o = field.get(instance);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    private void setValueToField(Field field, Object instance, Object value, String errorMsg) throws IllegalAccessException {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public List<FrameworkMethod> getChildren() {
        List<ESFuzzyTest> testsToRun = this.dataProvider.getTestsToRun();
        List allChildren = super.getChildren();
        if (testsToRun != null) {
            ArrayList<FrameworkMethod> filteredChildren = new ArrayList<FrameworkMethod>();
            for (ESFuzzyTest test : testsToRun) {
                String name = test.getName();
                int seedCount = test.getSeedCount();
                for (FrameworkMethod child : allChildren) {
                    if (seedCount != this.counter || !name.equals(child.getName())) continue;
                    filteredChildren.add(child);
                }
            }
            return filteredChildren;
        }
        return allChildren;
    }

    private String testName(String name) {
        return String.format("%s%s[%s]", name, " ", this.counter);
    }

    protected String testName(FrameworkMethod method) {
        return this.testName(method.getName());
    }

    protected String getName() {
        return String.format("%s%s[%s]", this.getTestClass().getName(), " ", this.counter);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }
}

