/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.common;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.junit.Assert;
import org.junit.Test;

public class ProjectCacheTest
extends ESTest {
    @Test
    public void testGetIdForCutElement() {
        final Project project = this.getProject();
        final TestElement cutElement = Create.testElement();
        final TestElement element = Create.testElement();
        new EMFStoreCommand(){

            protected void doRun() {
                project.getCutElements().add((Object)cutElement);
                project.addModelElement((EObject)element);
            }
        }.run(false);
        Assert.assertNotNull((Object)project.getModelElementId((EObject)element));
        Assert.assertNotNull((Object)project.getModelElementId((EObject)cutElement));
    }

    @Test
    public void testAddingObserverMustNotOverwriteExistingIDsWhileExecutingCommand() {
        final ModelElementId[] cutElementIWhileCommand = new ModelElementId[1];
        final Project project = this.getProject();
        final TestElement cutElement = Create.testElement();
        new EMFStoreCommand(){

            protected void doRun() {
                project.getCutElements().add((Object)cutElement);
                cutElementIWhileCommand[0] = project.getModelElementId((EObject)cutElement);
                project.addIdEObjectCollectionChangeObserver(ProjectCacheTest.this.createDummyObserver());
            }
        }.run(false);
        Assert.assertEquals((Object)cutElementIWhileCommand[0], (Object)project.getModelElementId((EObject)cutElement));
    }

    private IdEObjectCollectionChangeObserver createDummyObserver() {
        return new IdEObjectCollectionChangeObserver(){

            public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
            }

            public void modelElementRemoved(IdEObjectCollection collection, EObject eObject) {
            }

            public void modelElementAdded(IdEObjectCollection collection, EObject eObject) {
            }

            public void collectionDeleted(IdEObjectCollection collection) {
            }
        };
    }

    @Test
    public void testGetNoIdForDeletedElement() {
        final Project project = this.getProject();
        final TestElement element = Create.testElement();
        new EMFStoreCommand(){

            protected void doRun() {
                project.addModelElement((EObject)element);
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                project.deleteModelElement((EObject)element);
            }
        }.run(false);
        Assert.assertNull((Object)project.getModelElementId((EObject)element));
    }

    @Test
    public void testSwitchContainerInDifferentCommands() {
        final Project project = this.getProject();
        final TestElement element = Create.testElement();
        final TestElement container = Create.testElement();
        container.getContainedElements().add((Object)element);
        new EMFStoreCommand(){

            protected void doRun() {
                project.addModelElement((EObject)container);
                ProjectCacheTest.this.clearOperations();
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                element.setContainer(null);
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                container.getContainedElements().add((Object)element);
            }
        }.run(false);
    }

    @Test
    public void testSwitchContainerViaElement() {
        final Project project = this.getProject();
        final TestElement element = Create.testElement();
        final TestElement container = Create.testElement();
        container.getContainedElements().add((Object)element);
        final TestElement container2 = Create.testElement();
        new EMFStoreCommand(){

            protected void doRun() {
                project.addModelElement((EObject)container);
                project.addModelElement((EObject)container2);
                ProjectCacheTest.this.clearOperations();
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                element.setContainer(container2);
            }
        }.run(false);
    }

    @Test
    public void testSwitchContainerViaContainer() {
        final Project project = this.getProject();
        final TestElement element = Create.testElement();
        final TestElement container = Create.testElement();
        container.getContainedElements().add((Object)element);
        final TestElement container2 = Create.testElement();
        new EMFStoreCommand(){

            protected void doRun() {
                project.addModelElement((EObject)container);
                project.addModelElement((EObject)container2);
                ProjectCacheTest.this.clearOperations();
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                container.getContainedElements().remove((Object)element);
                container2.getContainedElements().add((Object)element);
            }
        }.run(false);
    }

    @Test
    public void testElementLosesItsContainer() {
        final Project project = this.getProject();
        final TestElement element = Create.testElement();
        final TestElement container = Create.testElement();
        container.getContainedElements().add((Object)element);
        new EMFStoreCommand(){

            protected void doRun() {
                project.addModelElement((EObject)container);
                ProjectCacheTest.this.clearOperations();
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                container.getContainedElements().add((Object)element);
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                element.setContainer(container);
            }
        }.run(false);
        new EMFStoreCommand(){

            protected void doRun() {
                container.getContainedElements().remove((Object)element);
                element.setContainer(null);
            }
        }.run(false);
    }
}

