/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidProjectIdException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public ProjectSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    @Override
    protected void initSubInterface() throws FatalESException {
        super.initSubInterface();
    }

    protected ProjectHistory getProject(ProjectId projectId) throws ESException {
        ProjectHistory projectHistory = this.getProjectOrNull(projectId);
        if (projectHistory != null) {
            return projectHistory;
        }
        throw new InvalidProjectIdException("Project with the id:" + (projectId == null ? "null" : projectId) + " doesn't exist.");
    }

    private ProjectHistory getProjectOrNull(ProjectId projectId) {
        for (ProjectHistory project : this.getServerSpace().getProjects()) {
            if (!project.getProjectId().equals(projectId)) continue;
            return project;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.GETPROJECT)
    public Project getProject(ProjectId projectId, VersionSpec versionSpec) throws InvalidVersionSpecException, ESException {
        this.sanityCheckObjects(projectId, versionSpec);
        Object object = this.getMonitor();
        synchronized (object) {
            PrimaryVersionSpec resolvedVersion = this.getSubInterface(VersionSubInterfaceImpl.class).resolveVersionSpec(projectId, versionSpec);
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, resolvedVersion);
            return this.getProject(version);
        }
    }

    protected Project getProject(Version version) throws InvalidVersionSpecException, ESException {
        if (version.getProjectState() == null) {
            ArrayList<Version> versions = new ArrayList<Version>();
            Version currentVersion = version;
            while (currentVersion.getProjectState() == null) {
                versions.add(currentVersion);
                currentVersion = VersionSubInterfaceImpl.findNextVersion(currentVersion);
            }
            if (currentVersion.getProjectState() == null) {
                throw new ESException("Couldn't find project state.");
            }
            Project projectState = (Project)ModelUtil.clone((EObject)currentVersion.getProjectState());
            Collections.reverse(versions);
            for (Version vers : versions) {
                vers.getChanges().apply(projectState);
            }
            return projectState;
        }
        return version.getProjectState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.GETPROJECTLIST)
    public List<ProjectInfo> getProjectList(SessionId sessionId) throws ESException {
        Object object = this.getMonitor();
        synchronized (object) {
            ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
            for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
                try {
                    this.getAuthorizationControl().checkReadAccess(sessionId, projectHistory.getProjectId(), null);
                    result.add(this.createProjectInfo(projectHistory));
                }
                catch (AccessControlException accessControlException) {}
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.CREATEEMPTYPROJECT)
    public ProjectInfo createProject(String name, String description, LogMessage logMessage) throws ESException {
        this.sanityCheckObjects(name, description, logMessage);
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = null;
            try {
                logMessage.setDate(new Date());
                projectHistory = this.createEmptyProject(name, description, logMessage, ModelFactory.eINSTANCE.createProject());
            }
            catch (FatalESException fatalESException) {
                throw new StorageException("Couldn't save data in database.");
            }
            return this.createProjectInfo(projectHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.CREATEPROJECT)
    public ProjectInfo createProject(String name, String description, LogMessage logMessage, Project project) throws ESException {
        this.sanityCheckObjects(name, description, logMessage, project);
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = null;
            try {
                logMessage.setDate(new Date());
                projectHistory = this.createEmptyProject(name, description, logMessage, project);
            }
            catch (FatalESException fatalESException) {
                throw new StorageException("Couldn't save data in database.");
            }
            return this.createProjectInfo(projectHistory);
        }
    }

    @EmfStoreMethod(value=EmfStoreMethod.MethodId.DELETEPROJECT)
    public void deleteProject(ProjectId projectId, boolean deleteFiles) throws ESException {
        this.sanityCheckObjects(projectId);
        this.deleteProject(projectId, deleteFiles, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void deleteProject(ProjectId projectId, boolean deleteFiles, boolean throwInvalidIdException) throws ESException {
        var4_4 = this.getMonitor();
        synchronized (var4_4) {
            try {
                project = this.getProject(projectId);
                this.getServerSpace().getProjects().remove((Object)project);
                try {
                    try {
                        this.save((EObject)this.getServerSpace());
                    }
                    catch (FatalESException v0) {
                        throw new StorageException("Couldn't save data in database.");
                    }
                }
                finally {
                    ** for (version : project.getVersions())
                }
lbl-1000:
                // 1 sources

                {
                    changes = version.getChanges();
                    if (changes != null) {
                        changes.eResource().delete(null);
                    }
                    if ((projectState = version.getProjectState()) != null) {
                        projectState.eResource().delete(null);
                    }
                    version.eResource().delete(null);
                    continue;
                }
lbl23:
                // 1 sources

                if (project.eResource() != null) {
                    project.eResource().delete(null);
                }
            }
            catch (InvalidProjectIdException e) {
                if (throwInvalidIdException) {
                    throw e;
                }
            }
            catch (IOException e) {
                throw new StorageException("Project resource files couldn't be deleted.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.IMPORTPROJECTHISTORYTOSERVER)
    public ProjectId importProjectHistoryToServer(ProjectHistory projectHistory) throws ESException {
        this.sanityCheckObjects(projectHistory);
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectOrNull = this.getProjectOrNull(projectHistory.getProjectId());
            if (projectOrNull != null) {
                projectHistory.setProjectId(org.eclipse.emf.emfstore.internal.server.model.ModelFactory.eINSTANCE.createProjectId());
            }
            try {
                this.getResourceHelper().createResourceForProjectHistory(projectHistory);
                this.getServerSpace().getProjects().add((Object)projectHistory);
                this.getResourceHelper().save((EObject)this.getServerSpace());
                for (Version version : projectHistory.getVersions()) {
                    if (version.getChanges() != null) {
                        this.getResourceHelper().createResourceForChangePackage(version.getChanges(), version.getPrimarySpec(), projectHistory.getProjectId());
                    }
                    if (version.getProjectState() != null) {
                        this.getResourceHelper().createResourceForProject(version.getProjectState(), version.getPrimarySpec(), projectHistory.getProjectId());
                    }
                    this.getResourceHelper().createResourceForVersion(version, projectHistory.getProjectId());
                }
                this.getResourceHelper().save((EObject)projectHistory);
                this.getResourceHelper().saveAll();
            }
            catch (FatalESException fatalESException) {
                this.deleteProject(projectHistory.getProjectId(), true, false);
                throw new StorageException("Couldn't save data in database.");
            }
            return (ProjectId)ModelUtil.clone((EObject)projectHistory.getProjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.EXPORTPROJECTHISTORYFROMSERVER)
    public ProjectHistory exportProjectHistoryFromServer(ProjectId projectId) throws ESException {
        this.sanityCheckObjects(projectId);
        Object object = this.getMonitor();
        synchronized (object) {
            return (ProjectHistory)ModelUtil.clone((EObject)this.getProject(projectId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectHistory createEmptyProject(String name, String description, LogMessage logMessage, Project initialProjectState) throws FatalESException {
        ProjectHistory projectHistory = org.eclipse.emf.emfstore.internal.server.model.ModelFactory.eINSTANCE.createProjectHistory();
        projectHistory.setProjectName(name);
        projectHistory.setProjectDescription(description);
        projectHistory.setProjectId(org.eclipse.emf.emfstore.internal.server.model.ModelFactory.eINSTANCE.createProjectId());
        Version firstVersion = VersioningFactory.eINSTANCE.createVersion();
        firstVersion.setLogMessage(logMessage);
        PrimaryVersionSpec primary = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        primary.setIdentifier(0);
        firstVersion.setPrimarySpec(primary);
        BranchInfo branchInfo = VersioningFactory.eINSTANCE.createBranchInfo();
        branchInfo.setName("trunk");
        branchInfo.setHead((PrimaryVersionSpec)ModelUtil.clone((EObject)primary));
        branchInfo.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)primary));
        projectHistory.getBranches().add((Object)branchInfo);
        Object object = this.getMonitor();
        synchronized (object) {
            this.getResourceHelper().createResourceForProject(initialProjectState, firstVersion.getPrimarySpec(), projectHistory.getProjectId());
            projectHistory.getVersions().add((Object)firstVersion);
            this.getResourceHelper().createResourceForVersion(firstVersion, projectHistory.getProjectId());
            this.getResourceHelper().createResourceForProjectHistory(projectHistory);
            this.getServerSpace().getProjects().add((Object)projectHistory);
            this.save((EObject)this.getServerSpace());
            firstVersion.setProjectStateResource(initialProjectState.eResource());
            return projectHistory;
        }
    }

    private ProjectInfo createProjectInfo(ProjectHistory project) {
        ProjectInfo info = org.eclipse.emf.emfstore.internal.server.model.ModelFactory.eINSTANCE.createProjectInfo();
        info.setName(project.getProjectName());
        info.setDescription(project.getProjectDescription());
        info.setProjectId((ProjectId)ModelUtil.clone((EObject)project.getProjectId()));
        info.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)project.getLastVersion().getPrimarySpec()));
        return info;
    }
}

