/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.internal.wizards.SelectEStructuralFeaturesWizard;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.composites.CheckedEStructuralFeatureComposite;
import org.eclipse.emf.ecp.view.internal.table.generator.TableColumnGenerator;
import org.eclipse.emf.ecp.view.spi.model.impl.VFeaturePathDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateColumnsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof VTableControl)) {
            return null;
        }
        VTableControl tableControl = (VTableControl)selection;
        VFeaturePathDomainModelReferenceImpl domainModelReference = (VFeaturePathDomainModelReferenceImpl)tableControl.getDomainModelReference();
        if (domainModelReference == null) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Cannot generate Columns", (String)"Please set the domain model reference before generating columns.");
            return null;
        }
        EStructuralFeature feature = domainModelReference.getDomainModelEFeature();
        if (feature == null) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Cannot generate Columns", (String)"Please set a feature in the domain model reference before generating columns.");
            return null;
        }
        EClassifier eType = feature.getEType();
        if (eType instanceof EClass) {
            Object[] attributesForColumns;
            EClass clazz = (EClass)eType;
            Object[] objectArray = attributesForColumns = this.getAttributesForColumns((EAttribute[])clazz.getEAttributes().toArray((Object[])new EAttribute[clazz.getEAttributes().size()]));
            int n = attributesForColumns.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof EAttribute) {
                    EAttribute a = (EAttribute)o;
                    TableColumnGenerator.addColumn((EAttribute)a, (VTableControl)tableControl);
                }
                ++n2;
            }
        }
        return null;
    }

    private Object[] getAttributesForColumns(EAttribute[] attributes) {
        SelectEStructuralFeaturesWizard wizard = new SelectEStructuralFeaturesWizard();
        CheckedEStructuralFeatureComposite compositeProvider = CompositeFactory.getCheckedTableSelectionComposite((Object)attributes);
        wizard.setCompositeProvider((CompositeProvider)compositeProvider);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        Object[] toReturn = new Object[]{};
        int result = wd.open();
        if (result == 0) {
            Object[] selection = compositeProvider.getSelection();
            if (selection == null || selection.length == 0) {
                return toReturn;
            }
            toReturn = selection;
        }
        return toReturn;
    }
}

