/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class RenameTracker {
    private final RevFilter filter = new RevFilter(){

        public boolean include(RevWalk walker, RevCommit commit) throws IOException {
            if (RenameTracker.this.currentPath != null) {
                RenameTracker.this.renames.put(commit, RenameTracker.this.currentPath);
            } else if (RenameTracker.this.currentDiff != null) {
                RenameTracker.this.renames.put(commit, RenameTracker.this.currentDiff.getNewPath());
                RenameTracker.this.currentPath = RenameTracker.this.currentDiff.getOldPath();
                RenameTracker.this.currentDiff = null;
            }
            return true;
        }

        public RevFilter clone() {
            return null;
        }
    };
    private final RenameCallback callback = new RenameCallback(){

        public void renamed(DiffEntry entry) {
            RenameTracker.this.currentDiff = entry;
            RenameTracker.this.currentPath = null;
        }
    };
    private String initialPath;
    private DiffEntry currentDiff;
    private String currentPath;
    private Map<RevCommit, String> renames = new LinkedHashMap<RevCommit, String>();

    RenameTracker() {
    }

    public RevFilter getFilter() {
        return this.filter;
    }

    public RenameCallback getCallback() {
        return this.callback;
    }

    public String getPath(ObjectId target, String startingPath) {
        if (!startingPath.equals(this.initialPath)) {
            return startingPath;
        }
        String renamed = this.renames.get(target);
        return renamed != null ? renamed : startingPath;
    }

    public RenameTracker reset(String path) {
        this.renames.clear();
        this.initialPath = path;
        this.currentPath = path;
        return this;
    }
}

