/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client.handler;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.request.Header;

public class SetCookieHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetCookieHandler.class);
    private static final Handler HANDLER = new SetCookieHandler();
    private static final String DELIM = "##";

    private SetCookieHandler() {
    }

    public static Handler getInstance() {
        return HANDLER;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        String setCookieHeader = responseHeader.getValue().toLowerCase();
        String expectedValues = configuredHeader.getValue().toLowerCase();
        LOGGER.trace("[SetCookieHandler] Set-Cookie header received: {}", (Object)setCookieHeader);
        StringTokenizer conf = new StringTokenizer(expectedValues, DELIM);
        while (conf.hasMoreTokens()) {
            String token;
            String token1 = token = conf.nextToken();
            if (token.endsWith("\"") && token.indexOf("=\"") > 1) {
                token1 = token.replace("=\"", "=");
                token1 = token1.substring(0, token.length() - 2);
            }
            if (token.startsWith("!")) {
                String attr = token.substring(1);
                String attr1 = token1.substring(1);
                if (!setCookieHeader.contains(attr) && !setCookieHeader.contains(attr1)) continue;
                LOGGER.trace("[SetCookieHandler] Unexpected attribute found  Set-Cookie header.  Attribute: {}\nSet-Cookie header: {}", (Object)attr, (Object)setCookieHeader);
                return false;
            }
            if (!setCookieHeader.contains(token) && !setCookieHeader.contains(token1)) {
                LOGGER.error("[SetCookieHandler] Unable to find '{}' within the Set-Cookie header returned by the server.", (Object)token);
                return false;
            }
            LOGGER.trace("[SetCookieHandler] Found expected value, '{}' in Set-Cookie header returned by server.", (Object)token);
        }
        return true;
    }
}

