/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.metadatacomplete;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.BaseTckTest;
import servlet.tck.spec.security.metadatacomplete.DenyAllServlet;
import servlet.tck.spec.security.metadatacomplete.GuestPageTestServlet;
import servlet.tck.spec.security.metadatacomplete.ServletSecTestServlet;
import servlet.tck.spec.security.metadatacomplete.UnProtectedTestServlet;

public class MetaDataCompleteTests
extends BaseTckTest {
    private static final String CLASS_TRACE_HEADER = "[Client]: ";
    private static final String USER_PRINCIPAL_SEARCH = "The user principal is: ";
    private String pageDeny = null;
    private String pageSec = null;
    private String pageGuest = null;
    private String pageUnprotected = null;
    private String pageServletBase = "/servlet_sec_metadatacomplete_web";
    private String pageServletDeny = this.pageServletBase + "/ServletDenyAll";
    private String pageServletSec = this.pageServletBase + "/ServletSecTest";
    private String pageServletGuest = this.pageServletBase + "/GuestPageTest";
    private String pageServletUnprotected = this.pageServletBase + "/UnProtectedTest";
    private String username = null;
    private String password = null;
    private String unauthUsername = null;
    private String unauthPassword = null;

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_sec_metadatacomplete_web.war")).addClasses(new Class[]{DenyAllServlet.class, GuestPageTestServlet.class, ServletSecTestServlet.class, UnProtectedTestServlet.class})).setWebXML(MetaDataCompleteTests.class.getResource("servlet_sec_metadatacomplete_web.xml"));
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
        try {
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.unauthUsername = p.getProperty("authuser");
            this.unauthPassword = p.getProperty("authpassword");
            this.pageSec = this.pageServletSec;
            this.pageDeny = this.pageServletDeny;
            this.pageGuest = this.pageServletGuest;
            this.pageUnprotected = this.pageServletUnprotected;
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    @Test
    public void test1() throws Exception {
        this.logger.trace("testing that we can NOT access: {}", (Object)this.pageDeny);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test1");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageDeny));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            this.logger.trace("we tested for Status Code=401 but we could have a 403 code, so check for that.");
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test1");
            ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageDeny));
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.logger.trace("test1 passed:  we were not allowed to perform GET on servlet: {}", (Object)this.pageDeny);
    }

    @Test
    public void test2() throws Exception {
        this.logger.trace("POST w/ user= {} should be allowed due to DD declaration", (Object)this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.logger.trace("GET w/ user= {} should be allowed due to DD declaration", (Object)this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", USER_PRINCIPAL_SEARCH + this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.logger.trace("success - DD's role access was honored while the conflicting annotation was ignored.");
        this.logger.trace("test2 passed.");
    }

    @Test
    public void test3() throws Exception {
        this.logger.trace("Attempting to POST as user= {} should be denied due to DD security.", (Object)this.username);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecurityAnno/Test3");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecurityAnno/Test3");
            ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageSec));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.logger.trace("Attempting to GET as user= {} should be allowed due to DD security.", (Object)this.username);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "BasicSec/Test3");
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.logger.trace("Class level annotation setting was overridden by DD.");
        this.logger.trace("test3 passed.");
    }

    @Test
    public void test4() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.logger.trace("Success - DD allowed POST by user={}", (Object)this.unauthUsername);
        this.logger.trace("test4 passed.");
    }

    @Test
    public void test5() throws Exception {
        this.logger.trace("GET w/ user= {} should be allowed access as DD leaves this servlet unprotected.", (Object)this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "BasicSec/Test5");
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageUnprotected));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.logger.trace("Class level PermitAll anno returned expected results");
        this.logger.trace("test5 passed.");
    }

    @Test
    public void test6() throws Exception {
        this.logger.trace("Sending request to resource where DD allows access to override any restricting annotation...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
        this.logger.trace("GET w/ user= {} should NOT be allowed due to DD declaration", (Object)this.username);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            this.logger.trace("retrying: GET w/ user= {} should still NOT be allowed due to DD declaration", (Object)this.username);
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
            ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("GET", this.pageGuest));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.logger.trace("POST w/ user= {} should NOT be allowed due to DD declaration", (Object)this.username);
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
        ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            this.logger.trace("retrying: POST w/ user= {} should still NOT be allowed due to DD declaration", (Object)this.username);
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
            ((Properties)TEST_PROPS.get()).setProperty("request", MetaDataCompleteTests.getRequestLine("POST", this.pageGuest));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.logger.trace("Success - we were not allowed to POST or GET as role=Administrator (user=j2ee).");
        this.logger.trace("Test6 passed.");
    }

    private static String getRequestLine(String method, String path) {
        return method + " " + path + " HTTP/1.1";
    }
}

