/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.cookie;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import servlet.tck.common.servlets.HttpTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends HttpTCKServlet {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    public static String CUSTOM_HEADER_DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public void cloneTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("cookie1", "value1");
        String cookieName = testCookie.getName();
        Cookie testCookieclone = (Cookie)testCookie.clone();
        String cloneName = testCookieclone.getName();
        if (!cloneName.equals(cookieName)) {
            passed = false;
            pw.println("Expected = " + cookieName);
            pw.println("Actual =" + cloneName);
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void constructorTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        String name1 = "name1";
        String value1 = "value1";
        Cookie testCookie = new Cookie(name1, value1);
        String cookieName = testCookie.getName();
        String cookieValue = testCookie.getValue();
        if (!cookieName.equals(name1) || !cookieValue.equals(value1)) {
            passed = false;
            pw.println("Expected = " + name1 + "," + value1);
            pw.println("Actual = " + cookieName + "," + cookieValue);
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void constructorIllegalArgumentExceptionTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] invalidNameValues = new String[]{",test", ";test", " test", "\ttest", "\ntest"};
        PrintWriter pw = response.getWriter();
        for (int i = 0; i < invalidNameValues.length; ++i) {
            pw.println("Attempting to create new Cookie with invalid name value: '" + invalidNameValues[i] + "'");
            try {
                Cookie c = new Cookie(invalidNameValues[i], "someValue");
                pw.println("Test FAILED.  IllegalArgumentException not thrown for invalid name value.");
            }
            catch (Throwable t) {
                if (!(t instanceof IllegalArgumentException)) {
                    pw.println("Test FAILED.  Exception thrown by Cookie constructor, but it wasn't an instance of IllegalArgumentExcepiton.");
                    pw.println("Actual Exception type: " + t.getClass().getName());
                }
                pw.println("IllegalArgumentException thrown for invalid value: '" + invalidNameValues[i] + "'");
            }
            pw.println();
        }
    }

    @Deprecated
    public void getCommentTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        testCookie.setComment("This is a comment");
        String result = testCookie.getComment();
        response.addCookie(testCookie);
        if (result == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getComment() returned an incorrect result");
            pw.println("Expected null value");
            pw.println("Actual = |" + result + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    @Deprecated
    public void getCommentNullTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String result = testCookie.getComment();
        if (result != null) {
            passed = false;
            pw.println("getComment() returned a non-null result");
            pw.println("Actual = |" + result + "|");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getDomainTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String expectedResult = "foo.bar";
        testCookie.setDomain(expectedResult);
        String result = testCookie.getDomain();
        response.addCookie(testCookie);
        if (expectedResult.equals(result)) {
            passed = true;
        } else {
            passed = false;
            pw.println("getDomain() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getMaxAgeTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = true;
        Cookie testCookie = new Cookie("name1", "value1");
        int expectedResult = 300;
        testCookie.setMaxAge(expectedResult);
        int result = testCookie.getMaxAge();
        if (result != expectedResult) {
            passed = false;
            pw.println("getMaxAge() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        }
        pw.println("default test");
        testCookie = new Cookie("name2", "value1");
        expectedResult = -1;
        result = testCookie.getMaxAge();
        if (result != expectedResult) {
            passed = false;
            pw.println("getMaxAge() returned an incorrect result");
            pw.println("Expected = " + expectedResult + EMPTY_STRING);
            pw.println("Actual = |" + result + "|");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getNameTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie[] cookie = request.getCookies();
        int index = ServletTestUtil.findCookie(cookie, "name1");
        if (index < 0) {
            passed = false;
            pw.println("Error: The expected cookie was not received from the client");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getPathTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String expectedResult = request.getContextPath();
        testCookie.setPath(expectedResult);
        String result = testCookie.getPath();
        response.addCookie(testCookie);
        if (expectedResult.equals(result)) {
            passed = true;
        } else {
            passed = false;
            pw.println("getPath() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getSecureTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = false;
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getAttributeSecureTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String result = testCookie.getAttribute("secure");
        response.addCookie(testCookie);
        if (result != null) {
            passed = false;
            pw.println("getAttribute(\"Secure\") returned non-null result");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getValueTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetValueTest(request, response, "value1");
    }

    public void getValueQuotedTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetValueTest(request, response, "\"value1\"");
    }

    private void doGetValueTest(HttpServletRequest request, HttpServletResponse response, String expectedResult) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie[] cookie = request.getCookies();
        int index = ServletTestUtil.findCookie(cookie, "name1");
        if (index >= 0) {
            String result = cookie[index].getValue();
            if (result != null) {
                if (!result.equals(expectedResult)) {
                    passed = false;
                    pw.println("getValue() returned an incorrect result ");
                    pw.println("Expected = " + expectedResult + " ");
                    pw.println("Actual = |" + result + "| ");
                } else {
                    passed = true;
                }
            } else {
                passed = false;
                pw.println("Error: getValue() returned a null result");
            }
        } else {
            passed = false;
            pw.println("Error: The expected cookie was not received from the client");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    @Deprecated
    public void getVersionTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        int expectedResult = 0;
        int result = testCookie.getVersion();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getVersion() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setDomainTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String expectedResult = "ENG.COM";
        testCookie.setDomain(expectedResult);
        String result = testCookie.getDomain();
        response.addCookie(testCookie);
        if (result != null) {
            if (!result.equalsIgnoreCase(expectedResult)) {
                passed = false;
                pw.println("setDomain(" + expectedResult + ") did not set the domain properly ");
                pw.println("Expected = " + expectedResult + " ");
                pw.println("Actual = |" + result + "| ");
            } else {
                passed = true;
            }
        } else {
            passed = false;
            pw.println("getDomain() returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setMaxAgePositiveTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        Cookie testCookie = new Cookie("name1", "value1");
        testCookie.setMaxAge(2);
        response.addCookie(testCookie);
        SimpleDateFormat sdf = new SimpleDateFormat(CUSTOM_HEADER_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date currDate = new Date();
        String dateString = sdf.format(currDate);
        response.addHeader("testDate", dateString);
        ServletTestUtil.printResult(pw, true);
    }

    public void setMaxAgeZeroTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        Cookie testCookie = new Cookie("name1", "value1");
        testCookie.setMaxAge(0);
        response.addCookie(testCookie);
        ServletTestUtil.printResult(pw, true);
    }

    public void setMaxAgeNegativeTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        Cookie testCookie = new Cookie("name1", "value1");
        testCookie.setMaxAge(-1);
        response.addCookie(testCookie);
        ServletTestUtil.printResult(pw, true);
    }

    public void setPathTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String expectedResult = "\"/servlet_jsh_cookie_web\"";
        testCookie.setPath(expectedResult);
        String result = testCookie.getPath();
        response.addCookie(testCookie);
        if (result != null) {
            if (!result.equals(expectedResult)) {
                passed = false;
                pw.println("setPath(" + expectedResult + ") returned an incorrect result");
                pw.println("Expected = " + expectedResult + " ");
                pw.println("Actual = |" + result + "| ");
            } else {
                passed = true;
            }
        } else {
            passed = false;
            pw.println("getPath() returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setSecureTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = true;
        testCookie.setSecure(expectedResult);
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setAttributeSecureTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = true;
        testCookie.setAttribute("secure", EMPTY_STRING);
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setAttributeSecureInvalidTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = false;
        testCookie.setAttribute("secure", "other");
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setValueTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String expectedResult = "value2";
        testCookie.setValue(expectedResult);
        String result = testCookie.getValue();
        response.addCookie(testCookie);
        if (result != null) {
            if (!result.equals(expectedResult)) {
                passed = false;
                pw.println("setValue(" + expectedResult + ") did not set the value properly");
                pw.println("Expected = " + expectedResult + " ");
                pw.println("Actual = |" + result + "| ");
            } else {
                passed = true;
            }
        } else {
            passed = false;
            pw.println("getValue() returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    @Deprecated
    public void setVersionVer0Test(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        int expectedResult = 0;
        testCookie.setVersion(expectedResult);
        int result = testCookie.getVersion();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("setVersion(" + expectedResult + ") did not set the version properly");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    @Deprecated
    public void setVersionVer1Test(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        int expectedResult = 0;
        testCookie.setVersion(1);
        int result = testCookie.getVersion();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("setVersion(" + expectedResult + ") did not set the version properly");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setAttributeTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = true;
        Cookie testCookie = new Cookie("name1", "value1");
        String attrName = "some-name";
        String attrValue = "some-value";
        testCookie.setAttribute(attrName, attrValue);
        String result = testCookie.getAttribute(attrName);
        response.addCookie(testCookie);
        if (result != null) {
            if (!result.equalsIgnoreCase(attrValue)) {
                passed = false;
                pw.println("setAttribute(" + attrName + "," + attrValue + ") did not set the attribute properly ");
                pw.println("Expected value = " + attrValue + " ");
                pw.println("Actual value = |" + result + "| ");
            }
        } else {
            passed = false;
            pw.println("getAttribute(" + attrName + ") returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getAttributesTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = true;
        String name = "name1";
        String value = "value1";
        Cookie testCookie = new Cookie(name, value);
        String attrName = "some-name";
        String attrValue = "some-value";
        testCookie.setAttribute(attrName, attrValue);
        Map result = testCookie.getAttributes();
        response.addCookie(testCookie);
        if (result != null) {
            if (result.size() == 1) {
                if (!((String)result.get(attrName)).equals(attrValue)) {
                    passed = false;
                    pw.println("getAttributes() returned a map that contained [" + (String)result.get(attrName) + "] as the value for key [" + attrName + "] rather than [" + attrValue + "]");
                }
            } else {
                passed = false;
                pw.println("getAttributes() returned a map of size [" + result.size() + "] rather than 1.");
            }
        } else {
            passed = false;
            pw.println("getAttributes() returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getHttpOnlyTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = false;
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getAttributeHttpOnlyTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        String result = testCookie.getAttribute("secure");
        response.addCookie(testCookie);
        if (result != null) {
            passed = false;
            pw.println("getAttribute(\"Secure\") returned non-null result");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setHttpOnlyTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = true;
        testCookie.setSecure(expectedResult);
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setAttributeHttpOnlyTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = true;
        testCookie.setAttribute("secure", EMPTY_STRING);
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setAttributeHttpOnlyInvalidTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        Cookie testCookie = new Cookie("name1", "value1");
        boolean expectedResult = false;
        testCookie.setAttribute("secure", "other");
        boolean result = testCookie.getSecure();
        response.addCookie(testCookie);
        if (result != expectedResult) {
            passed = false;
            pw.println("getSecure() returned an incorrect result ");
            pw.println("Expected = " + expectedResult + " ");
            pw.println("Actual = |" + result + "| ");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setPartitionedTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        Cookie testCookie = new Cookie("name1", "value1");
        testCookie.setAttribute("Partitioned", EMPTY_STRING);
        response.addCookie(testCookie);
        ServletTestUtil.printResult(pw, true);
    }
}

