/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.interceptor;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.filter.interceptor.EntityReaderInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.interceptor.EntityWriterInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.interceptor.Resource;
import ee.jakarta.tck.ws.rs.spec.filter.interceptor.TSAppConfig;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public static final String plaincontent = JAXRSClientIT.class.getName();
    public static final String content = "<content>" + plaincontent + "</content>";

    private static String getJaxbToken() {
        JAXBElement element = new JAXBElement(new QName("content"), String.class, (Object)plaincontent);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{String.class});
            StringWriter writer = new StringWriter();
            context.createMarshaller().marshal((Object)element, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_filter_interceptor_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/filter/interceptor/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_filter_interceptor_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, EntityReaderInterceptor.class, EntityWriterInterceptor.class, StringStreamingOutput.class, StringDataSource.class, StringSource.class, ReplacingOutputStream.class, JaxrsUtil.class, StringBean.class, StringBeanEntityProvider.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void byteArrayReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postbytearray"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for bytearray provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void byteArrayReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postbytearray"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void byteArrayWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getbytearray"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for bytearray provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void byteArrayWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getbytearray"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void byteArrayWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.addProvider(EntityWriterInterceptor.class);
        this.setRequestContentEntity(content.getBytes());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for bytearray provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for string provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void stringWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getstring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for string provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getstring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void stringWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for string provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void inputStreamReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postinputstream"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for inputstream provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void inputStreamReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postinputstream"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void inputStreamWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getinputstream"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for inputstream provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void inputStreamWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getinputstream"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void inputStreamWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setRequestContentEntity(stream);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for inputstream provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void readerReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postreader"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for reader provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void readerReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postreader"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void readerWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getreader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for reader provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void readerWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getreader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void readerWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes());
        InputStreamReader reader = new InputStreamReader(bais);
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setRequestContentEntity(reader);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for reader provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void fileReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postfile"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for file provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void fileReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postfile"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void fileWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getfile"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for file provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void fileWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getfile"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void fileWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        try {
            File file = File.createTempFile("temp", "tmp");
            FileWriter fw = new FileWriter(file);
            fw.append(content);
            fw.close();
            this.setRequestContentEntity(file);
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for file provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void dataSourceReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postdatasource"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for dataSource provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void dataSourceReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postdatasource"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void dataSourceWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getdatasource"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for dataSource provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void dataSourceWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getdatasource"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void dataSourceWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        StringDataSource source = new StringDataSource(content, MediaType.WILDCARD_TYPE);
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setRequestContentEntity(source);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postdatasource"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for dataSource provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void sourceWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getsource"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for source provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void sourceWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getsource"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postjaxb"));
        this.setRequestContentEntity(JAXRSClientIT.getJaxbToken());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for jaxb provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postjaxb"));
        this.setRequestContentEntity(JAXRSClientIT.getJaxbToken());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, plaincontent);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getjaxb"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for jaxb provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getjaxb"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        JAXBElement element = new JAXBElement(new QName("element"), String.class, (Object)content);
        GenericEntity<JAXBElement<String>> entity = new GenericEntity<JAXBElement<String>>(element){};
        this.addProvider(EntityWriterInterceptor.class);
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for JAXBElement provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringBeanReaderContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststringbean"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered reader interceptor for StringBean provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringBeanReaderNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststringbean"));
        this.setRequestContentEntity(content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void stringBeanWriterContainerInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getstringbean"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for StringBean provider");
    }

    @Test
    @Tag(value="xml_binding")
    public void stringBeanWriterNoInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getstringbean"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.getName());
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void stringBeanWriterClientInterceptorTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(EntityWriterInterceptor.class);
        this.addProvider(EntityWriterInterceptor.class);
        this.addProvider(StringBeanEntityProvider.class);
        this.setRequestContentEntity(new StringBean(content));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EntityWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FROM_RESOURCE");
        this.invoke();
        JAXRSClientIT.logMsg("JAXRS called registered writer interceptor for StringBean provider");
    }

    private void addInterceptors(Class<?> clazz) {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "FILTER_HEADER:" + clazz.getName());
    }
}

