/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.client.asyncinvoker;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JdkLoggingFilter;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.ee.rs.client.asyncinvoker.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.client.asyncinvoker.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -696868584437674095L;
    protected long millis;
    protected int callbackResult = 0;
    protected Throwable callbackException = null;
    private static final String NONEXISTING_SITE = "somenonexisting.domain-site";
    static final String[] METHODS = new String[]{"DELETE", "GET", "OPTIONS"};
    static final String[] ENTITY_METHODS = new String[]{"PUT", "POST"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("jaxrs_ee_rs_client_asyncinvoker_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/client/asyncinvoker/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_client_asyncinvoker_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, StringBean.class, TRACE.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void deleteTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("delete");
        Future future = async.delete();
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void deleteWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        Future future = async.delete();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void deleteThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("delete");
        Future future = async.delete();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        Future future = async.delete(String.class);
        this.checkFutureString(future, "delete");
    }

    @Test
    public void deleteWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        Future future = async.delete(Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void deleteWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("delete");
        Future future = async.delete(String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        Future future = async.delete(String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        Future future = async.delete(Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void deleteWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.delete(generic);
        this.checkFutureString(future, "delete");
    }

    @Test
    public void deleteWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.delete(generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("delete");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.delete(generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.delete(generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.delete(generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void deleteWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        InvocationCallback<Response> callback = this.createCallback(true);
        Future future = async.delete(callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void deleteWithCallbackStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        InvocationCallback<String> callback = this.createStringCallback(true);
        Future future = async.delete(callback);
        this.checkFutureString(future, "delete");
        this.assertCallbackCall();
    }

    @Test
    public void deleteWithCallbackStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("deleteandwait");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.delete(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithCallbackStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.delete(callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("deletenotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.delete(callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("get");
        Future future = async.get();
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void getWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        Future future = async.get();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("get");
        Future future = async.get();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        Future future = async.get(String.class);
        this.checkFutureString(future, "get");
    }

    @Test
    public void getWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        Future future = async.get(Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("get");
        Future future = async.get(String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        Future future = async.get(String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        Future future = async.get(Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.get(generic);
        this.checkFutureString(future, "get");
    }

    @Test
    public void getWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.get(generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("get");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.get(generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.get(generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.get(generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        InvocationCallback<Response> callback = this.createCallback(true);
        Future future = async.get(callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void getWithCallbackStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getandwait");
        InvocationCallback<String> callback = this.createStringCallback(true);
        Future future = async.get(callback);
        this.checkFutureString(future, "get");
        this.assertCallbackCall();
    }

    @Test
    public void getWithCallbackStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("get");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.get(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithCallbackStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.get(callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("getnotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.get(callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void headTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("head");
        Future future = async.head();
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void headWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("headandwait");
        Future future = async.head();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void headThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("head");
        Future future = async.head();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void headWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("headandwait");
        InvocationCallback<Response> callback = this.createCallback(true);
        Future future = async.head(callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void headWithCallbackStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("head");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.head(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void methodTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method);
            this.checkFutureOkResponseNoTime(future);
        }
    }

    @Test
    public void methodWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, String.class);
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, Response.class);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method, String.class);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, String.class);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, Response.class);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, generic);
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, generic);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method, generic);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, generic);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, generic);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<Response> callback = this.createCallback(true);
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, callback);
            this.checkFutureOkResponse(future);
            this.assertCallbackCall();
        }
    }

    @Test
    public void methodWithCallbackStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createStringCallback(true);
        Future future = null;
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            future = async.method(method, callback);
            this.checkFutureString(future, method);
            this.assertCallbackCall();
        }
    }

    @Test
    public void methodWithCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        InvocationCallback<String> callback = this.createStringCallback(false);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method, callback);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithCallbackThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<String> callback = this.createStringCallback(false);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, callback);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<Response> callback = this.createCallback(false);
        for (String method : METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            future = async.method(method, callback);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        for (String method : ENTITY_METHODS) {
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            future = async.method(method, entity);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithStringClassWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, String.class);
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithResponseClassWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, Response.class);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, String.class);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, String.class);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, Response.class);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, generic);
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithGenericTypeResponseWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, generic);
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, generic);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, generic);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, generic);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithCallbackWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<Response> callback = this.createCallback(true);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, callback);
            this.checkFutureOkResponse(future);
            this.assertCallbackCall();
        }
    }

    @Test
    public void methodWithCallbackStringWithEntityWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<String> callback = this.createStringCallback(true);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "andwait");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, callback);
            this.checkFutureString(future, method);
            this.assertCallbackCall();
        }
    }

    @Test
    public void methodWithCallbackWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = null;
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, callback);
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithCallbackWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<String> callback = this.createStringCallback(false);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, callback);
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithCallbackWithEntityThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Future future = null;
        InvocationCallback<Response> callback = this.createCallback(false);
        for (String method : ENTITY_METHODS) {
            AsyncInvoker async = this.startAsyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = async.method(method, entity, callback);
            this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void optionsTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("options");
        Future future = async.options();
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void optionsWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        Future future = async.options();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void optionsThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("options");
        Future future = async.options();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        Future future = async.options(String.class);
        this.checkFutureString(future, "options");
    }

    @Test
    public void optionsWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        Future future = async.options(Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void optionsWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("options");
        Future future = async.options(String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        Future future = async.options(String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        Future future = async.options(Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void optionsWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.options(generic);
        this.checkFutureString(future, "options");
    }

    @Test
    public void optionsWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.options(generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("options");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.options(generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.options(generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.options(generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void optionsWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        InvocationCallback<Response> callback = this.createCallback(true);
        Future future = async.options(callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void optionsWithStringCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsandwait");
        InvocationCallback<String> callback = this.createStringCallback(true);
        Future future = async.options(callback);
        this.checkFutureString(future, "options");
        this.assertCallbackCall();
    }

    @Test
    public void optionsWithCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("options");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.options(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithCallbackThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.options(callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("optionsnotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.options(callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("post");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity);
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void postWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("post");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Future future = async.post(entity, String.class);
        this.checkFutureString(future, "post");
    }

    @Test
    public void postWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Future future = async.post(entity, Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("post");
        Future future = async.post(entity, String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        Future future = async.post(entity, String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity, Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Future future = async.post(entity, generic);
        this.checkFutureString(future, "post");
    }

    @Test
    public void postWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Future future = async.post(entity, generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        GenericType<String> generic = this.createGeneric(String.class);
        AsyncInvoker async = this.startAsyncInvokerForMethod("post");
        Future future = async.post(entity, generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        GenericType<String> generic = this.createGeneric(String.class);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        Future future = async.post(entity, generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity, generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        InvocationCallback<Response> callback = this.createCallback(true);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postandwait");
        Future future = async.post(entity, callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void postWithCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        InvocationCallback<String> callback = this.createStringCallback(false);
        AsyncInvoker async = this.startAsyncInvokerForMethod("post");
        Future future = async.post(entity, callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithCallbackThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        InvocationCallback<String> callback = this.createStringCallback(false);
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        Future future = async.post(entity, callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("postnotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.post(entity, callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("put");
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.put(entity);
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void putWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.put(entity);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("put");
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        Future future = async.put(entity);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, String.class);
        this.checkFutureString(future, "put");
    }

    @Test
    public void putWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("put");
        Future future = async.put(entity, String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        Future future = async.put(entity, String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        Future future = async.put(entity, Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, generic);
        this.checkFutureString(future, "put");
    }

    @Test
    public void putWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("put");
        Future future = async.put(entity, generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        Future future = async.put(entity, generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.put(entity, generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        InvocationCallback<Response> callback = this.createCallback(true);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void putWithStringCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        InvocationCallback<String> callback = this.createStringCallback(true);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putandwait");
        Future future = async.put(entity, callback);
        this.checkFutureString(future, "put");
        this.assertCallbackCall();
    }

    @Test
    public void putWithCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        InvocationCallback<String> callback = this.createStringCallback(false);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("put");
        Future future = async.put(entity, callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithCallbackThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createStringCallback(false);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        Future future = async.put(entity, callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        AsyncInvoker async = this.startAsyncInvokerForMethod("putnotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.put(entity, callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("trace");
        Future future = async.trace();
        this.checkFutureOkResponseNoTime(future);
    }

    @Test
    public void traceWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("trace");
        Future future = async.trace();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithStringClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(String.class);
        this.checkFutureString(future, "trace");
    }

    @Test
    public void traceWithResponseClassWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(Response.class);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        AsyncInvoker async = this.startAsyncInvokerForMethod("trace");
        Future future = async.trace(String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        Future future = async.trace(String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        Future future = async.trace(Response.class);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceWithGenericTypeStringWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(generic);
        this.checkFutureString(future, "trace");
    }

    @Test
    public void traceWithGenericTypeResponseWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(generic);
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        AsyncInvoker async = this.startAsyncInvokerForMethod("trace");
        Future future = async.trace(generic);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        GenericType<String> generic = this.createGeneric(String.class);
        Future future = async.trace(generic);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Future future = async.trace(generic);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceWithCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<Response> callback = this.createCallback(true);
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(callback);
        this.checkFutureOkResponse(future);
        this.assertCallbackCall();
    }

    @Test
    public void traceWithStringCallbackWhileServerWaitTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createStringCallback(true);
        AsyncInvoker async = this.startAsyncInvokerForMethod("traceandwait");
        Future future = async.trace(callback);
        this.checkFutureString(future, "trace");
        this.assertCallbackCall();
    }

    @Test
    public void traceWithCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        InvocationCallback<String> callback = this.createStringCallback(false);
        AsyncInvoker async = this.startAsyncInvokerForMethod("trace");
        Future future = async.trace(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithCallbackThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        InvocationCallback<String> callback = this.createStringCallback(false);
        Future future = async.trace(callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithCallbackThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        AsyncInvoker async = this.startAsyncInvokerForMethod("tracenotok");
        InvocationCallback<Response> callback = this.createCallback(false);
        Future future = async.trace(callback);
        this.checkFutureStatusResponseNoTime(future, Response.Status.NOT_ACCEPTABLE);
    }

    protected String getUrl(String method) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this._hostname).append(":").append(this._port);
        url.append("/").append(this.getContextRoot()).append("/").append(method);
        return url.toString();
    }

    protected AsyncInvoker startAsyncInvokerForMethod(String methodName) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(false));
        WebTarget target = client.target(this.getUrl(methodName));
        AsyncInvoker async = target.request().async();
        this.setStartTime();
        return async;
    }

    protected void assertOkAndLog(Response response, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((response.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Returned unexpected status" + response.getStatus()));
        String msg = "Returned status " + status.getStatusCode() + " (" + status.name() + ")";
        TestUtil.logMsg(msg);
    }

    protected void checkFutureOkResponseNoTime(Future<Response> future) throws JAXRSCommonClient.Fault {
        this.checkFutureStatusResponseNoTime(future, Response.Status.OK);
    }

    protected void checkFutureStatusResponseNoTime(Future<Response> future, Response.Status status) throws JAXRSCommonClient.Fault {
        Response response = null;
        try {
            response = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.assertOkAndLog(response, status);
    }

    protected void checkFutureOkResponse(Future<Response> future) throws JAXRSCommonClient.Fault {
        this.checkMaxEndTime();
        Assertions.assertTrue((!future.isDone() ? 1 : 0) != 0, (String)"Future cannot be done, yet!");
        this.checkFutureOkResponseNoTime(future);
    }

    protected void checkFutureString(Future<String> future, String expectedValue) throws JAXRSCommonClient.Fault {
        this.checkMaxEndTime();
        Assertions.assertTrue((!future.isDone() ? 1 : 0) != 0, (String)"Future cannot be done, yet!");
        String value = null;
        try {
            value = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        Assertions.assertTrue((boolean)expectedValue.equalsIgnoreCase(value), (String)("expected value" + expectedValue + "differes from acquired value" + value));
    }

    protected void assertExceptionWithWebApplicationExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertWebApplicationExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertExceptionWithProcessingExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertProcessingExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertProcessingExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        Assertions.assertTrue((boolean)JAXRSClientIT.hasWrapped(e, ProcessingException.class), (String)("ExecutionException wrapped" + e.getCause() + "rather then ProcessingException"));
        JAXRSClientIT.logMsg("ExecutionException.getCause is ProcessingException as expected");
    }

    protected void assertWebApplicationExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        Assertions.assertTrue((boolean)JAXRSClientIT.hasWrapped(e, WebApplicationException.class), (String)("ExecutionException wrapped" + e.getCause() + "rather then WebApplicationException"));
        JAXRSClientIT.logMsg("ExecutionException.getCause is WebApplicationException as expected");
    }

    static boolean hasWrapped(Throwable parent, Class<? extends Throwable> wrapped) {
        while (parent.getCause() != null) {
            if (wrapped.isInstance(parent.getCause())) {
                return true;
            }
            parent = parent.getCause();
        }
        return false;
    }

    protected void sleep(int millis) throws JAXRSCommonClient.Fault {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    protected void setStartTime() {
        this.millis = System.currentTimeMillis();
        JAXRSClientIT.logMsg("Start time:", this.millis);
    }

    protected void checkMaxEndTime() throws JAXRSCommonClient.Fault {
        long endMillis = System.currentTimeMillis();
        long diff = endMillis - this.millis;
        JAXRSClientIT.logMsg("Client was returned control in", diff, "milliseconds from request");
        Assertions.assertTrue((diff <= 2000L ? 1 : 0) != 0, (String)"AsyncInvoker was blocked waiting for a response");
    }

    protected void checkMinEndTime() throws JAXRSCommonClient.Fault {
        long endMillis = System.currentTimeMillis();
        long diff = endMillis - this.millis;
        JAXRSClientIT.logMsg("Callback#completed() called in", diff, "milliseconds from request");
        Assertions.assertTrue((diff >= 2000L ? 1 : 0) != 0, (String)("AsyncInvoker.completed() was called unexpectedly soon, after" + diff + "milliseconds"));
    }

    protected void assertCallbackCall() throws JAXRSCommonClient.Fault {
        while (this.callbackResult == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        switch (this.callbackResult) {
            case 1: {
                JAXRSClientIT.logMsg("Callback completed() call ok");
                break;
            }
            case 2: 
            case 3: {
                JAXRSClientIT.logMsg("Callback completed() call failed with error");
                throw new JAXRSCommonClient.Fault("Callback call failed with error", this.callbackException);
            }
        }
        this.callbackResult = 0;
    }

    protected <T> GenericType<T> createGeneric(Class<T> clazz) {
        return new GenericType(clazz);
    }

    protected InvocationCallback<Response> createCallback(boolean check) {
        Callback<Response> callback = new Callback<Response>(check){

            public void completed(Response response) {
                this.checkEndTime();
            }
        };
        return callback;
    }

    protected InvocationCallback<String> createStringCallback(boolean check) {
        Callback<String> callback = new Callback<String>(check){

            public void completed(String response) {
                this.checkEndTime();
            }
        };
        return callback;
    }

    abstract class Callback<RESPONSE>
    implements InvocationCallback<RESPONSE> {
        protected boolean check;

        public Callback(boolean check) {
            this.check = check;
        }

        protected void checkEndTime() {
            if (this.check) {
                try {
                    JAXRSClientIT.this.checkMinEndTime();
                    JAXRSClientIT.this.callbackResult = 1;
                }
                catch (JAXRSCommonClient.Fault e) {
                    JAXRSClientIT.this.callbackResult = 2;
                    JAXRSClientIT.this.callbackException = e;
                    throw new RuntimeException(e);
                }
            }
        }

        public void failed(Throwable throwable) {
            if (this.check) {
                JAXRSClientIT.this.callbackResult = 3;
                JAXRSClientIT.this.callbackException = throwable;
                throw new RuntimeException(throwable);
            }
        }
    }
}

