/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.impl.ComponentDefinition;
import org.glassfish.deployment.common.Descriptor;

public class EjbContext
extends ResourceContainerContextImpl {
    private final Method[] methods;
    private final boolean inherited;
    private final ArrayList<PostProcessInfo> postProcessInfos = new ArrayList();
    private WebServiceEndpoint endpoint;

    public EjbContext(EjbDescriptor currentEjb, Class<?> ejbClass) {
        super((Descriptor)currentEjb);
        this.componentClassName = currentEjb.getEjbClassName();
        ComponentDefinition cdef = new ComponentDefinition(ejbClass);
        this.methods = cdef.getMethods();
        Class<?> superClass = ejbClass.getSuperclass();
        this.inherited = superClass != null && !Object.class.equals(superClass);
    }

    public EjbDescriptor getDescriptor() {
        return (EjbDescriptor)this.descriptor;
    }

    public void setDescriptor(EjbDescriptor currentEjb) {
        this.descriptor = (Descriptor)currentEjb;
    }

    public void setEndpoint(WebServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void endElement(ElementType type, AnnotatedElement element) throws AnnotationProcessorException {
        if (ElementType.TYPE.equals((Object)type)) {
            for (PostProcessInfo ppInfo : this.postProcessInfos) {
                ppInfo.postProcessor.postProcessAnnotation(ppInfo.ainfo, this);
            }
            this.getProcessingContext().popHandler();
        }
    }

    public Class<?> getDeclaringClass(MethodDescriptor md) {
        Method method = md.getMethod(this.getDescriptor());
        for (Method m : this.methods) {
            if (!TypeUtil.sameMethodSignature(m, method)) continue;
            return m.getDeclaringClass();
        }
        return null;
    }

    public Method[] getComponentDefinitionMethods() {
        return this.methods;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void addPostProcessInfo(AnnotationInfo ainfo, PostProcessor<EjbContext> postProcessor) {
        PostProcessInfo ppInfo = new PostProcessInfo();
        ppInfo.ainfo = ainfo;
        ppInfo.postProcessor = postProcessor;
        this.postProcessInfos.add(ppInfo);
    }

    @Override
    public HandlerChainContainer[] getHandlerChainContainers(boolean serviceSideHandlerChain, Class<?> declaringClass) {
        EjbBundleDescriptor bundleDescriptor = this.getDescriptor().getEjbBundleDescriptor();
        if (serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = bundleDescriptor.getEjbByClassName(declaringClass.getName());
            ArrayList<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(bundleDescriptor.getWebServices().getEndpointsImplementedBy(ejb));
            }
            return result.toArray(new HandlerChainContainer[result.size()]);
        }
        ArrayList<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
        result.addAll(bundleDescriptor.getEjbServiceReferenceDescriptors());
        return result.toArray(new HandlerChainContainer[result.size()]);
    }

    private static class PostProcessInfo {
        public AnnotationInfo ainfo;
        public PostProcessor<EjbContext> postProcessor;

        private PostProcessInfo() {
        }
    }
}

