/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.util.Hashtable;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Type;

public final class Identifier
implements Constants {
    static Hashtable<String, Identifier> hash = new Hashtable(3001, 0.5f);
    String name;
    Object value;
    Type typeObject = null;
    private int ipos;
    public static final char INNERCLASS_PREFIX = ' ';
    private static final String ambigPrefix = "<<ambiguous>>";

    private Identifier(String name) {
        this.name = name;
        this.ipos = name.indexOf(32);
    }

    int getType() {
        return this.value != null && this.value instanceof Integer ? (Integer)this.value : 60;
    }

    void setType(int t) {
        this.value = t;
    }

    public static synchronized Identifier lookup(String s) {
        Identifier id = hash.get(s);
        if (id == null) {
            id = new Identifier(s);
            hash.put(s, id);
        }
        return id;
    }

    public static Identifier lookup(Identifier q, Identifier n) {
        if (q == idNull) {
            return n;
        }
        if (q.name.charAt(q.name.length() - 1) == ' ') {
            return Identifier.lookup(q.name + n.name);
        }
        Identifier id = Identifier.lookup(q + "." + n);
        if (!n.isQualified() && !q.isInner()) {
            id.value = q;
        }
        return id;
    }

    public static Identifier lookupInner(Identifier c, Identifier n) {
        Identifier id = c.isInner() ? (c.name.charAt(c.name.length() - 1) == ' ' ? Identifier.lookup(c.name + n) : Identifier.lookup(c, n)) : Identifier.lookup(c + "." + ' ' + n);
        id.value = c.value;
        return id;
    }

    public String toString() {
        return this.name;
    }

    public boolean isQualified() {
        if (this.value == null) {
            int idot = this.ipos;
            idot = idot <= 0 ? this.name.length() : --idot;
            int index = this.name.lastIndexOf(46, idot - 1);
            this.value = index < 0 ? idNull : Identifier.lookup(this.name.substring(0, index));
        }
        return this.value instanceof Identifier && this.value != idNull;
    }

    public Identifier getQualifier() {
        return this.isQualified() ? (Identifier)this.value : idNull;
    }

    public Identifier getName() {
        return this.isQualified() ? Identifier.lookup(this.name.substring(((Identifier)this.value).name.length() + 1)) : this;
    }

    public boolean isInner() {
        return this.ipos > 0;
    }

    public Identifier getFlatName() {
        if (this.isQualified()) {
            return this.getName().getFlatName();
        }
        if (this.ipos > 0 && this.name.charAt(this.ipos - 1) == '.') {
            if (this.ipos + 1 == this.name.length()) {
                return Identifier.lookup(this.name.substring(0, this.ipos - 1));
            }
            String n = this.name.substring(this.ipos + 1);
            String t = this.name.substring(0, this.ipos);
            return Identifier.lookup(t + n);
        }
        return this;
    }

    public Identifier getTopName() {
        if (!this.isInner()) {
            return this;
        }
        return Identifier.lookup(this.getQualifier(), this.getFlatName().getHead());
    }

    public Identifier getHead() {
        Identifier id = this;
        while (id.isQualified()) {
            id = id.getQualifier();
        }
        return id;
    }

    public Identifier getTail() {
        Identifier id = this.getHead();
        if (id == this) {
            return idNull;
        }
        return Identifier.lookup(this.name.substring(id.name.length() + 1));
    }

    public boolean hasAmbigPrefix() {
        return this.name.startsWith(ambigPrefix);
    }

    public Identifier addAmbigPrefix() {
        return Identifier.lookup(ambigPrefix + this.name);
    }

    public Identifier removeAmbigPrefix() {
        if (this.hasAmbigPrefix()) {
            return Identifier.lookup(this.name.substring(ambigPrefix.length()));
        }
        return this;
    }
}

