/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.core;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@ApplicationScoped
public class Messages {
    private static final String BASENAME = "krazo";
    @Inject
    private HttpServletRequest request;

    public String get(String key, Object ... params) {
        if (this.request != null) {
            Enumeration locales = this.request.getLocales();
            while (locales.hasMoreElements()) {
                String message = this.get(key, (Locale)locales.nextElement(), params);
                if (message == null) continue;
                return message;
            }
        }
        return this.get(key, Locale.ENGLISH, params);
    }

    public String get(String key, Locale locale, Object ... params) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(BASENAME, locale);
            String pattern = rb.getString(key);
            return MessageFormat.format(pattern, params);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

