/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextUtil;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.naming.InitialContext;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ServerContextImpl
implements ServerContext,
PostConstruct {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    StartupContext startupContext;
    @Inject
    ServiceLocator services;
    File instanceRoot;
    String[] args;

    public void postConstruct() {
        this.instanceRoot = this.env.getInstanceRoot();
        this.args = new String[this.startupContext.getArguments().size() * 2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : this.startupContext.getArguments().entrySet()) {
            this.args[i++] = entry.getKey().toString();
            this.args[i++] = entry.getValue().toString();
        }
    }

    public File getInstanceRoot() {
        return this.instanceRoot;
    }

    public String[] getCmdLineArgs() {
        return this.args;
    }

    public File getInstallRoot() {
        return StartupContextUtil.getInstallRoot((StartupContext)this.startupContext);
    }

    public String getInstanceName() {
        return this.env.getInstanceName();
    }

    public String getServerConfigURL() {
        File domainXML = new File(this.instanceRoot, "config");
        domainXML = new File(domainXML, "domain.xml");
        return domainXML.toURI().toString();
    }

    public Server getConfigBean() {
        return (Server)this.services.getService(Server.class, new Annotation[0]);
    }

    public InitialContext getInitialContext() {
        GlassfishNamingManager gfNamingManager = (GlassfishNamingManager)this.services.getService(GlassfishNamingManager.class, new Annotation[0]);
        return (InitialContext)gfNamingManager.getInitialContext();
    }

    public ClassLoader getCommonClassLoader() {
        return ((CommonClassLoaderServiceImpl)this.services.getService(CommonClassLoaderServiceImpl.class, new Annotation[0])).getCommonClassLoader();
    }

    public ClassLoader getSharedClassLoader() {
        return ((ClassLoaderHierarchy)this.services.getService(ClassLoaderHierarchy.class, new Annotation[0])).getConnectorClassLoader(null);
    }

    public ClassLoader getLifecycleParentClassLoader() {
        return ((ClassLoaderHierarchy)this.services.getService(ClassLoaderHierarchy.class, new Annotation[0])).getConnectorClassLoader(null);
    }

    public InvocationManager getInvocationManager() {
        return (InvocationManager)this.services.getService(InvocationManager.class, new Annotation[0]);
    }

    public String getDefaultDomainName() {
        return "glassfish-web";
    }

    public ServiceLocator getDefaultServices() {
        return this.services;
    }
}

