/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class DefaultHandler
extends ErrHandler {
    private static boolean DEBUG = false;

    @Override
    public void sendError(IMQConnection con, BrokerException ex, Packet pkt) {
        this.logger.logStack(32, "B3100", "Uncaught Exception", (Throwable)ex);
        this.sendError(con, pkt, ex.getMessage(), ex.getStatusCode());
    }

    @Override
    public void sendError(IMQConnection con, Packet msg, String emsg, int status) {
        this.sendError(con, msg.getSendAcknowledge(), msg.getPacketType(), msg.getConsumerID(), emsg, status);
    }

    @Override
    public void sendError(IMQConnection con, boolean sendack, int pktype, long consumerID, String emsg, int status) {
        if (sendack) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(pktype + 1);
            pkt.setConsumerID(consumerID);
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("JMQStatus", status);
            if (emsg != null) {
                hash.put("JMQReason", emsg);
            }
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
        }
    }

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        if (msg.getSendAcknowledge()) {
            if (DEBUG) {
                this.logger.log(4, "DefaultHandler: replying to unknown packet type: " + msg.getPacketType());
            }
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(msg.getPacketType() + 1);
            pkt.setConsumerID(msg.getConsumerID());
            Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
            hash.put("JMQStatus", 501);
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
        } else if (DEBUG) {
            this.logger.log(4, "DefaultHandler: ignoring unknown packet type : " + msg.getPacketType());
        }
        return true;
    }
}

