/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.persistence;

import ee.jakarta.tck.data.standalone.persistence.Product;
import jakarta.data.Order;
import jakarta.data.repository.By;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Find;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Param;
import jakarta.data.repository.Query;
import jakarta.data.repository.Repository;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@Repository
public interface Catalog
extends DataRepository<Product, String> {
    @Insert
    public Product add(Product var1);

    @Insert
    public Product[] addMultiple(Product ... var1);

    @Find
    public Optional<Product> get(String var1);

    @Update
    public Product modify(Product var1);

    @Update
    public Product[] modifyMultiple(Product ... var1);

    @Delete
    public void remove(Product var1);

    @Delete
    public void removeMultiple(Product ... var1);

    @Save
    public void save(Product var1);

    @Delete
    public void deleteById(@By(value="id(this)") String var1);

    public long deleteByProductNumLike(String var1);

    public long countByPriceGreaterThanEqual(Double var1);

    @Query(value="WHERE LENGTH(name) = ?1 AND price < ?2 ORDER BY name")
    public List<Product> findByNameLengthAndPriceBelow(int var1, double var2);

    public List<Product> findByNameLike(String var1);

    @OrderBy(value="price", descending=true)
    public Stream<Product> findByPriceNotNullAndPriceLessThanEqual(double var1);

    public List<Product> findByPriceNull();

    public List<Product> findByProductNumBetween(String var1, String var2, Order<Product> var3);

    public List<Product> findByProductNumLike(String var1);

    @Query(value="FROM Product WHERE (:rate * price <= :max AND :rate * price >= :min) ORDER BY name")
    public Stream<Product> withTaxBetween(@Param(value="min") double var1, @Param(value="max") double var3, @Param(value="rate") double var5);
}

