/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet.TestClassloaderRunnableWork;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet.TestJNDIRunnableWork;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet.TestWorkInterface;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import java.util.Properties;

@WebServlet(value={"/ProxyCreatorServlet"})
public class ProxyCreatorServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(ProxyCreatorServlet.class);
    @Resource(lookup="java:comp/DefaultContextService")
    private ContextService context;

    public void testJNDIContextInServlet(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Object proxy = true;
        String result = null;
        String proxyURLString = req.getParameter("proxyURL");
        log.info("Proxy URL from parameter", proxyURLString);
        URL url = new URL(proxyURLString);
        proxy = this.context.createContextualProxy((Object)new TestJNDIRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class, Serializable.class});
        Properties p = new Properties();
        p.setProperty("proxy", this.proxyToString(proxy));
        result = ProxyCreatorServlet.getResponse(ProxyCreatorServlet.sendPostData(url, p));
        resp.getWriter().println(result);
    }

    public void testClassloaderInServlet(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Object proxy = true;
        String result = null;
        String proxyURLString = req.getParameter("proxyURL");
        log.info("Proxy URL from parameter", proxyURLString);
        URL url = new URL(proxyURLString);
        proxy = this.context.createContextualProxy((Object)new TestClassloaderRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class, Serializable.class});
        Properties p = new Properties();
        p.setProperty("proxy", this.proxyToString(proxy));
        result = ProxyCreatorServlet.getResponse(ProxyCreatorServlet.sendPostData(url, p));
        resp.getWriter().println(result);
    }

    private String proxyToString(Object proxy) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(proxy);
        out.close();
        return Base64.getEncoder().encodeToString(bout.toByteArray());
    }
}

