/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.test;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.HistoryPackage;
import org.eclipse.emf.edapt.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.migration.test.MigrationTestCase;
import org.eclipse.emf.edapt.migration.test.TestCaseDefinition;
import org.eclipse.emf.edapt.migration.test.TestPackage;
import org.eclipse.emf.edapt.migration.test.TestSuiteDefinition;

public class MigrationTestSuite
extends TestSuite {
    private final TestSuiteDefinition suiteDefinition;
    private Migrator migrator;
    private IClassLoader loader;

    public MigrationTestSuite(URI definitionURI, IClassLoader loader) throws IOException {
        this(MigrationTestSuite.loadTestSuiteDefinition(definitionURI));
        this.loader = loader;
    }

    private static TestSuiteDefinition loadTestSuiteDefinition(URI definitionURI) throws IOException {
        TestPackage.eINSTANCE.getTestCaseDefinition();
        return (TestSuiteDefinition)ResourceUtils.loadElement((URI)definitionURI);
    }

    public MigrationTestSuite(TestSuiteDefinition suiteDefinition) {
        super(suiteDefinition.getName());
        this.suiteDefinition = suiteDefinition;
        for (TestCaseDefinition caseDefinition : suiteDefinition.getCases()) {
            this.addTest((Test)new MigrationTestCase(this, caseDefinition));
        }
    }

    public void run(TestResult result) {
        try {
            this.migrator = this.loadMigrator();
            super.run(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private URI getURI(String uri) {
        URI definitionURI = this.suiteDefinition.eResource().getURI();
        return URI.createFileURI((String)uri).resolve(definitionURI);
    }

    private History loadHistory() throws IOException {
        HistoryPackage.eINSTANCE.getHistory();
        URI historyURI = this.getURI(this.suiteDefinition.getHistory());
        History history = (History)ResourceUtils.loadElement((URI)historyURI);
        return history;
    }

    Migrator getMigrator() {
        return this.migrator;
    }

    private Migrator loadMigrator() throws IOException {
        History history = this.loadHistory();
        Migrator migrator = new Migrator(history, this.loader);
        migrator.setLevel(ValidationLevel.CHANGE);
        return migrator;
    }
}

