/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.provider.HistoryEditPlugin;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelFilterUtils;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelOrderFilter;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelResourceFilter;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.IDiffModelFilter;
import org.eclipse.emf.edapt.history.reconstruction.ModelAssert;
import org.eclipse.emf.edapt.history.util.HistoryUtils;

public class IntegrityChecker {
    private final History history;
    private DiffResourceSet diffResourceSet;

    public IntegrityChecker(History history) {
        this.history = history;
    }

    public boolean check() {
        try {
            EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"reconstructed"));
            reconstructor.reconstruct(this.history.getLastRelease(), false);
            Resource originalResource = HistoryUtils.getRootResource((ResourceSet)this.history.eResource().getResourceSet());
            MatchResourceSet matchResourceSet = MatchService.doResourceSetMatch((ResourceSet)originalResource.getResourceSet(), (ResourceSet)reconstructor.getResourceSet(), Collections.emptyMap());
            this.diffResourceSet = DiffService.doDiff((MatchResourceSet)matchResourceSet);
            IDiffModelFilter filter = DiffModelFilterUtils.and(DiffModelOrderFilter.INSTANCE, DiffModelResourceFilter.INSTANCE);
            DiffModelFilterUtils.filter(this.diffResourceSet, filter);
            return ModelAssert.numberOfChanges(this.diffResourceSet) == 0;
        }
        catch (InterruptedException e) {
            LoggingUtils.logError((Plugin)HistoryEditPlugin.getPlugin(), (Throwable)e);
            return false;
        }
    }

    public DiffResourceSet getDiffModel() {
        return this.diffResourceSet;
    }
}

