/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edapt.common.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtils {
    public static final String PLATFORM_SCHEME = "platform";
    public static final String ECORE_FILE_EXTENSION = "ecore";

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    private ResourceUtils() {
    }

    public static ResourceSet loadResourceSet(URI modelURI, List<EPackage> ePackages) throws IOException {
        return ResourceUtils.loadResourceSet(Collections.singletonList(modelURI), ePackages);
    }

    public static ResourceSet loadResourceSet(List<URI> modelURIs, List<EPackage> ePackages) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ResourceUtils.register(ePackages, resourceSet.getPackageRegistry());
        HashMap options = new HashMap();
        for (URI modelURI : modelURIs) {
            if (ResourceUtils.isPathmap(modelURI)) continue;
            Resource resource = resourceSet.createResource(modelURI);
            try {
                resource.load(options);
            }
            catch (Resource.IOWrappedException e) {
                EList errors = resource.getErrors();
                if (errors.size() > 0) {
                    System.err.println(resource.getURI() + ": " + errors.size() + " errors");
                    continue;
                }
                throw e;
            }
        }
        ResourceUtils.resolveAll((ResourceSet)resourceSet);
        return resourceSet;
    }

    public static ResourceSet loadResourceSet(URI modelURI) throws IOException {
        return ResourceUtils.loadResourceSet(modelURI, new ArrayList<EPackage>());
    }

    public static Map<String, EPackage> register(List<EPackage> ePackages, EPackage.Registry registry) {
        HashMap<String, EPackage> backup = new HashMap<String, EPackage>();
        ResourceUtils.register(ePackages, registry, backup);
        return backup;
    }

    private static void register(List<EPackage> ePackages, EPackage.Registry registry, Map<String, EPackage> backup) {
        for (EPackage p : ePackages) {
            String nsURI = p.getNsURI();
            EPackage old = (EPackage)registry.put((Object)nsURI, (Object)p);
            backup.put(nsURI, old);
            ResourceUtils.register((List<EPackage>)p.getESubpackages(), registry, backup);
        }
    }

    public static ResourceSet loadResourceSet(String fileName, List<EPackage> ePackages) throws IOException {
        return ResourceUtils.loadResourceSet(URI.createFileURI((String)fileName), ePackages);
    }

    public static ResourceSet loadResourceSet(String fileName) throws IOException {
        return ResourceUtils.loadResourceSet(fileName, new ArrayList<EPackage>());
    }

    public static void saveResourceSet(ResourceSet resourceSet) throws IOException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.FALSE);
        for (Resource resource : resourceSet.getResources()) {
            if (resource.getURI() == null || resource.getURI().isPlatformPlugin() || ResourceUtils.isPathmap(resource.getURI())) continue;
            resource.save(options);
        }
    }

    public static boolean isPathmap(URI uri) {
        return "pathmap".equals(uri.scheme());
    }

    public static Resource loadResource(URI uri) throws IOException {
        ResourceSet resourceSet = ResourceUtils.loadResourceSet(uri);
        if (!resourceSet.getResources().isEmpty()) {
            return (Resource)resourceSet.getResources().get(0);
        }
        return null;
    }

    public static <V extends EObject> V loadElement(URI uri) throws IOException {
        Resource resource = ResourceUtils.loadResource(uri);
        if (!resource.getContents().isEmpty()) {
            return (V)((EObject)resource.getContents().get(0));
        }
        return null;
    }

    public static Resource saveElement(URI uri, EObject element) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)element);
        resource.save(null);
        return resource;
    }

    public static boolean exists(URI uri) throws IOException {
        try {
            URIUtils.getURL(uri).openStream().close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static <E extends EObject> List<E> getRootElements(ResourceSet resourceSet, Class<E> type) {
        ArrayList<E> rootElements = new ArrayList<E>();
        for (Resource resource : resourceSet.getResources()) {
            rootElements.addAll(ResourceUtils.getRootElements(resource, type));
        }
        return rootElements;
    }

    public static <E extends EObject> List<E> getRootElements(Resource resource, Class<E> type) {
        ArrayList<EObject> rootElements = new ArrayList<EObject>();
        for (EObject rootElement : resource.getContents()) {
            if (!type.isInstance(rootElement)) continue;
            rootElements.add(rootElement);
        }
        return rootElements;
    }

    public static boolean isPlatformResource(Resource resource) {
        return resource != null && PLATFORM_SCHEME.equals(resource.getURI().scheme());
    }

    public static void resolveAll(ResourceSet resourceSet) {
        HashSet<Resource> resolved = new HashSet<Resource>();
        boolean newFound = true;
        while (newFound) {
            newFound = false;
            for (Resource r : new ArrayList(resourceSet.getResources())) {
                if (resolved.contains(r)) continue;
                newFound = true;
                EcoreUtil.resolveAll((Resource)r);
                resolved.add(r);
            }
        }
    }
}

