/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetamodelUtils {
    static final String GENERIC = "Generic";

    private MetamodelUtils() {
    }

    public static boolean isGenericReference(EReference reference) {
        return reference.getEReferenceType() == EcorePackage.eINSTANCE.getEGenericType();
    }

    public static EReference getNonGenericReference(EReference genericReference) {
        EClass c = genericReference.getEContainingClass();
        String referenceName = genericReference.getName().replace(GENERIC, "");
        EReference nonGenericReference = (EReference)c.getEStructuralFeature(referenceName);
        return nonGenericReference;
    }

    public static EReference getGenericReference(EReference reference) {
        String name = reference.getName();
        name = String.valueOf(name.charAt(0)) + GENERIC + name.substring(1);
        return (EReference)reference.getEContainingClass().getEStructuralFeature(name);
    }

    public static List<EOperation> getOperations(EClass eClass, String name) {
        ArrayList<EOperation> operations = new ArrayList<EOperation>();
        for (EOperation operation : eClass.getEOperations()) {
            if (!name.equals(operation.getName())) continue;
            operations.add(operation);
        }
        return operations;
    }

    public static EOperation getOperation(EClass eClass, String name, EClassifier ... parameterTypes) {
        List<EOperation> operations = MetamodelUtils.getOperations(eClass, name);
        if (operations.size() == 1) {
            return operations.get(0);
        }
        Iterator<EOperation> i = operations.iterator();
        while (i.hasNext()) {
            EOperation operation = i.next();
            if (operation.getEParameters().size() == parameterTypes.length) continue;
            i.remove();
        }
        if (operations.size() == 1) {
            return operations.get(0);
        }
        for (EOperation operation : operations) {
            boolean found = true;
            int i2 = 0;
            for (EParameter parameter : operation.getEParameters()) {
                if (parameter.isMany()) {
                    if (parameterTypes[i2] != EcorePackage.eINSTANCE.getEEList()) {
                        found = false;
                    }
                } else if (parameterTypes[i2] != parameter.getEType()) {
                    found = false;
                }
                ++i2;
            }
            if (!found) continue;
            return operation;
        }
        return null;
    }

    public static <V extends EModelElement> V copy(V modelElement) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                Object value;
                if (eReference == EcorePackage.eINSTANCE.getEReference_EOpposite() && eObject.eIsSet((EStructuralFeature)eReference) && this.get(value = eObject.eGet((EStructuralFeature)eReference)) == null) {
                    return;
                }
                super.copyReference(eReference, eObject, copyEObject);
            }
        };
        EModelElement result = (EModelElement)copier.copy(modelElement);
        copier.copyReferences();
        return (V)result;
    }

    public static Collection<EPackage> getAllRootPackages(ResourceSet resourceSet) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (Resource resource : resourceSet.getResources()) {
            if (!MetamodelUtils.isMetamodelResource(resource)) continue;
            for (EObject o : resource.getContents()) {
                if (!(o instanceof EPackage)) continue;
                EPackage p = (EPackage)o;
                result.add(p);
            }
        }
        return result;
    }

    public static boolean isMetamodelResource(Resource resource) {
        URI uri = resource.getURI();
        return MetamodelUtils.isMetamodelURI(uri);
    }

    public static boolean isMetamodelURI(URI uri) {
        return "ecore".equals(uri.fileExtension());
    }

    public static EPackage getRootPackage(ResourceSet resourceSet) {
        Resource resource = (Resource)resourceSet.getResources().get(0);
        return (EPackage)resource.getContents().get(0);
    }

    public static boolean isConcrete(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    public static List<EClass> subtractTypes(EClass minuend, EClass subtrahend) {
        ArrayList<EClass> superTypes = new ArrayList<EClass>();
        superTypes.addAll((Collection<EClass>)minuend.getEAllSuperTypes());
        superTypes.add(0, minuend);
        superTypes.removeAll((Collection<?>)subtrahend.getEAllSuperTypes());
        superTypes.remove(subtrahend);
        return superTypes;
    }

    public static List<EStructuralFeature> subtractFeatures(EClass minuend, EClass subtrahend) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        List<EClass> superTypes = MetamodelUtils.subtractTypes(minuend, subtrahend);
        for (EClass superType : superTypes) {
            features.addAll((Collection<EStructuralFeature>)superType.getEStructuralFeatures());
        }
        return features;
    }
}

