/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean success;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int handle = OS.gtk_font_selection_dialog_new(titleBytes);
        if (this.parent != null) {
            int shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(handle, shellHandle);
            int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0) {
                OS.gtk_window_set_icon_list(handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            int group = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(group, handle);
        }
        OS.gtk_window_set_modal(handle, true);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            int fontName = OS.pango_font_description_to_string(font.handle);
            int length = OS.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, fontName, length);
            font.dispose();
            OS.g_free(fontName);
            OS.gtk_font_selection_dialog_set_font_name(handle, buffer);
        }
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        int hookId = 0;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0);
        }
        int response = OS.gtk_dialog_run(handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = response == -5;
        if (success) {
            int fontName = OS.gtk_font_selection_dialog_get_font_name(handle);
            int length = OS.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, fontName, length);
            OS.g_free(fontName);
            int fontDesc = OS.pango_font_description_from_string(buffer);
            Font font = Font.gtk_new(display, fontDesc);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(fontDesc);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        if (!success) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

