/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        boolean useChooserDialog;
        boolean bl = useChooserDialog = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (useChooserDialog) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        long path;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        long shellHandle = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long handle = 0L;
        handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L) : OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0L);
        if (handle == 0L) {
            this.error(2);
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            long group = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(group, handle);
        }
        OS.gtk_window_set_modal(handle, true);
        long pixbufs = OS.gtk_window_get_icon_list(shellHandle);
        if (pixbufs != 0L) {
            OS.gtk_window_set_icon_list(handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                stringBuffer.append(SEPARATOR);
            }
            stringBuffer.append(this.filterPath);
            byte[] buffer = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
            long ptr = OS.realpath(buffer, null);
            if (ptr != 0L) {
                OS.gtk_file_chooser_set_current_folder(handle, ptr);
                OS.g_free(ptr);
            }
        }
        if (this.message.length() > 0) {
            long label;
            byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
            long box = OS.gtk_hbox_new(false, 0);
            if (box == 0L) {
                this.error(2);
            }
            if ((label = OS.gtk_label_new(buffer)) == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(box, label);
            OS.gtk_widget_show(label);
            OS.gtk_label_set_line_wrap(label, true);
            OS.gtk_label_set_justify(label, 2);
            OS.gtk_file_chooser_set_extra_widget(handle, box);
        }
        String answer = null;
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        int response = OS.gtk_dialog_run(handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        if (response == -5 && (path = OS.gtk_file_chooser_get_filename(handle)) != 0L) {
            long utf8Ptr = OS.g_filename_to_utf8(path, -1L, null, null, null);
            OS.g_free(path);
            if (utf8Ptr != 0L) {
                long[] items_written = new long[1];
                long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                OS.g_free(utf8Ptr);
                if (utf16Ptr != 0L) {
                    int clength = (int)items_written[0];
                    char[] chars = new char[clength];
                    OS.memmove(chars, utf16Ptr, (long)(clength * 2));
                    OS.g_free(utf16Ptr);
                    this.filterPath = answer = new String(chars);
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        return answer;
    }

    String openClassicDialog() {
        long fileNamePtr;
        long utf8Ptr;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        long handle = OS.gtk_file_selection_new(titleBytes);
        if (this.parent != null) {
            long shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(handle, shellHandle);
            long pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0L) {
                OS.gtk_window_set_icon_list(handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        OS.gtk_window_set_modal(handle, true);
        String answer = null;
        if (this.filterPath != null) {
            String path = this.filterPath;
            if (path.length() > 0 && !path.endsWith(SEPARATOR)) {
                path = String.valueOf(path) + SEPARATOR;
            }
            int length = path.length();
            char[] buffer = new char[length + 1];
            path.getChars(0, length, buffer, 0);
            long utf8Ptr2 = OS.g_utf16_to_utf8(buffer, -1L, null, null, null);
            long fileNamePtr2 = OS.g_filename_from_utf8(utf8Ptr2, -1L, null, null, null);
            OS.gtk_file_selection_set_filename(handle, fileNamePtr2);
            OS.g_free(utf8Ptr2);
            OS.g_free(fileNamePtr2);
        }
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove(selection, handle);
        OS.gtk_file_selection_hide_fileop_buttons(handle);
        long fileListParent = OS.gtk_widget_get_parent(selection.file_list);
        OS.gtk_widget_hide(selection.file_list);
        OS.gtk_widget_hide(fileListParent);
        if (this.message.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
            long labelHandle = OS.gtk_label_new(buffer);
            OS.gtk_label_set_line_wrap(labelHandle, true);
            OS.gtk_misc_set_alignment(labelHandle, 0.0f, 0.0f);
            OS.gtk_container_add(selection.main_vbox, labelHandle);
            OS.gtk_box_set_child_packing(selection.main_vbox, labelHandle, false, false, 0, 0);
            OS.gtk_widget_show(labelHandle);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        int response = OS.gtk_dialog_run(handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        if (response == -5 && (utf8Ptr = OS.g_filename_to_utf8(fileNamePtr = OS.gtk_file_selection_get_filename(handle), -1L, null, null, null)) != 0L) {
            long[] items_written = new long[1];
            long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
            if (utf16Ptr != 0L) {
                int length = (int)items_written[0];
                char[] buffer = new char[length];
                OS.memmove(buffer, utf16Ptr, (long)(length * 2));
                String osAnswer = new String(buffer);
                if (osAnswer != null) {
                    if (!osAnswer.equals(SEPARATOR) && osAnswer.endsWith(SEPARATOR)) {
                        osAnswer = osAnswer.substring(0, osAnswer.length() - 1);
                    }
                    answer = this.filterPath = osAnswer;
                }
                OS.g_free(utf16Ptr);
            }
            OS.g_free(utf8Ptr);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

