/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceWriter {
    private StringBuffer buf;
    private Locale locale;
    private boolean isXML;

    public PreferenceWriter(StringBuffer buf, Locale locale) {
        this(buf, locale, false);
    }

    public PreferenceWriter(StringBuffer buf, Locale locale, boolean isXML) {
        this.buf = buf;
        this.locale = locale;
        this.isXML = isXML;
    }

    public void writePreferences() {
        this.writePreference("org.eclipse.help");
        this.writePreference("org.eclipse.help.base");
    }

    private void writePreference(String plugin) {
        try {
            InstanceScope instanceScope = new InstanceScope();
            IEclipsePreferences prefs = instanceScope.getNode(plugin);
            HashSet<String> keySet = new HashSet<String>();
            keySet.addAll(Arrays.asList(prefs.keys()));
            DefaultScope defaultScope = new DefaultScope();
            prefs = defaultScope.getNode(plugin);
            keySet.addAll(Arrays.asList(prefs.keys()));
            Object[] allKeys = keySet.toArray(new String[keySet.size()]);
            if (allKeys.length > 0) {
                Arrays.sort(allKeys);
                if (!this.isXML) {
                    this.buf.append("\n<h3>");
                    this.buf.append(plugin);
                    this.buf.append("</h3>\n");
                    this.buf.append("<table>");
                } else {
                    this.buf.append("\n    <plugin\n          title=\"");
                    this.buf.append(XMLGenerator.xmlEscape(plugin));
                    this.buf.append("\">");
                }
                int i = 0;
                while (i < allKeys.length) {
                    Object key = allKeys[i];
                    String value = Platform.getPreferencesService().getString(plugin, (String)key, "", null);
                    if (!this.isXML) {
                        this.buf.append("\n    <tr>\n");
                        this.buf.append("        <td>");
                        this.buf.append(UrlUtil.htmlEncode((String)key));
                        this.buf.append("</td>\n        <td>");
                        this.buf.append(UrlUtil.htmlEncode(value));
                        this.buf.append("</td>\n    </tr>");
                    } else {
                        this.buf.append("\n        <");
                        this.buf.append((String)key);
                        this.buf.append(">");
                        this.buf.append(value);
                        this.buf.append("</");
                        this.buf.append((String)key);
                        this.buf.append(">");
                    }
                    ++i;
                }
                if (!this.isXML) {
                    this.buf.append("\n</table>");
                } else {
                    this.buf.append("\n    </plugin>");
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.buf.append(WebappResources.getString("badPreferences", this.locale));
        }
    }
}

