/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SelectionServiceImpl
implements ESelectionService {
    static final String OUT_SELECTION = "output.selection";
    private ListenerList genericListeners = new ListenerList();
    private Map<String, ListenerList> targetedListeners = new HashMap<String, ListenerList>();
    private Set<IEclipseContext> tracked = new HashSet<IEclipseContext>();
    @Inject
    UISynchronize synchService;
    private EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MPart part;
            IEclipseContext context;
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPart && (context = (part = (MPart)element).getContext()) != null && SelectionServiceImpl.this.isInContainer(part)) {
                SelectionServiceImpl.this.track(part);
            }
        }
    };
    private MPart activePart;
    private IEclipseContext context;
    private EPartService partService;
    private MWindow window;
    private EModelService modelService;
    private IEventBroker eventBroker;

    @Inject
    SelectionServiceImpl(MWindow window, IEclipseContext context, EPartService partService, EModelService modelService, IEventBroker eventBroker) {
        this.context = context;
        this.partService = partService;
        this.window = window;
        this.modelService = modelService;
        this.eventBroker = eventBroker;
    }

    @PreDestroy
    void preDestroy() {
        this.genericListeners.clear();
        this.targetedListeners.clear();
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/Context", "context"), this.eventHandler);
        for (MPart part : this.partService.getParts()) {
            this.track(part);
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        if (part != null && this.activePart != part) {
            this.activePart = part;
            IEclipseContext partContext = part.getContext();
            if (partContext.containsKey(OUT_SELECTION)) {
                Object selection = partContext.get(OUT_SELECTION);
                this.notifyListeners(part, selection);
            }
            this.track(part);
        }
    }

    private boolean isInContainer(MPart part) {
        return this.modelService.findElements((MUIElement)this.window, part.getElementId(), MPart.class, null).contains(part);
    }

    private void notifyListeners(MPart part, Object selection) {
        this.context.set("selection", selection);
        Object[] objectArray = this.genericListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionListener)listener).selectionChanged(part, selection);
            ++n2;
        }
        this.notifyTargetedListeners(part, selection);
    }

    private void notifyTargetedListeners(MPart part, Object selection) {
        ListenerList listenerList;
        String id = part.getElementId();
        if (id != null && (listenerList = this.targetedListeners.get(id)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ISelectionListener)listener).selectionChanged(part, selection);
                ++n2;
            }
        }
    }

    private void track(final MPart part) {
        IEclipseContext context = part.getContext();
        if (context != null && this.tracked.add(context)) {
            context.runAndTrack(new RunAndTrack(){
                private boolean initial = true;

                public boolean changed(IEclipseContext context) {
                    final Object selection = context.get(SelectionServiceImpl.OUT_SELECTION);
                    if (this.initial) {
                        this.initial = false;
                        if (selection == null) {
                            return true;
                        }
                    }
                    if (SelectionServiceImpl.this.activePart == part) {
                        SelectionServiceImpl.this.synchService.asyncExec(new Runnable(){

                            public void run() {
                                SelectionServiceImpl.this.notifyListeners(part, selection);
                            }
                        });
                    } else {
                        SelectionServiceImpl.this.synchService.asyncExec(new Runnable(){

                            public void run() {
                                SelectionServiceImpl.this.notifyTargetedListeners(part, selection);
                            }
                        });
                    }
                    return true;
                }
            });
        }
    }

    void internalSetSelection(Object selection) {
        if (selection != null) {
            this.context.set("selection", selection);
        } else {
            this.context.remove("selection");
        }
    }

    public void setSelection(Object selection) {
        throw new UnsupportedOperationException("Cannot set the selection of a window");
    }

    public Object getSelection() {
        if (this.activePart == null) {
            return null;
        }
        IEclipseContext partContext = this.activePart.getContext();
        return partContext == null ? null : partContext.get("in.selection");
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.genericListeners.add((Object)listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        if (this.context != null) {
            this.genericListeners.remove((Object)listener);
        }
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new ListenerList();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add((Object)listener);
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners;
        if (this.context != null && (listeners = this.targetedListeners.get(partId)) != null) {
            listeners.remove((Object)listener);
        }
    }

    public Object getSelection(String partId) {
        MPart part = this.partService.findPart(partId);
        if (part == null) {
            return null;
        }
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            return null;
        }
        return partContext.get(OUT_SELECTION);
    }
}

