/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.GradientBackgroundListener;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyBackgroundSWTHandler
extends AbstractCSSPropertyBackgroundHandler {
    public static final ICSSPropertyBackgroundHandler INSTANCE = new CSSPropertyBackgroundSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            super.applyCSSProperty(element, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            return super.retrieveCSSProperty((Object)widget, property, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyBackgroundColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)((WidgetElement)element).getNativeWidget();
        if (value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
            if (widget instanceof CTabItem) {
                CTabFolder folder = ((CTabItem)widget).getParent();
                if ("selected".equals(pseudo)) {
                    folder.setSelectionBackground(newColor);
                } else {
                    folder.setBackground(newColor);
                }
            } else if (widget instanceof Control) {
                ((Control)widget).setBackground(newColor);
            }
        } else if (value.getCssValueType() == 2) {
            Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)widget.getDisplay());
            if (widget instanceof CTabItem && "selected".equals(pseudo)) {
                CTabFolder folder = ((CTabItem)widget).getParent();
                folder.setSelectionBackground(CSSSWTColorHelper.getSWTColors(grad, folder.getDisplay(), engine), CSSSWTColorHelper.getPercents(grad), true);
            } else if (widget instanceof Control) {
                GradientBackgroundListener.handle((Control)widget, grad);
            }
        }
    }

    public void applyCSSPropertyBackgroundImage(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget control = (Widget)((WidgetElement)element).getNativeWidget();
        Image image = (Image)engine.convert(value, Image.class, (Object)control.getDisplay());
        if (control instanceof CTabFolder && "selected".equals(pseudo)) {
            ((CTabFolder)control).setSelectionBackground(image);
        } else if (control instanceof Button) {
            Button button = (Button)control;
            button.setImage(image);
        } else {
            try {
                if (control instanceof Control) {
                    ((Control)control).setBackgroundImage(image);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public String retrieveCSSPropertyBackgroundAttachment(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        Color color = null;
        if (widget instanceof CTabItem) {
            color = "selected".equals(pseudo) ? ((CTabItem)widget).getParent().getSelectionBackground() : ((CTabItem)widget).getParent().getBackground();
        } else if (widget instanceof Control) {
            color = ((Control)widget).getBackground();
        }
        return engine.convert((Object)color, Color.class, null);
    }

    public String retrieveCSSPropertyBackgroundImage(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return "none";
    }

    public String retrieveCSSPropertyBackgroundPosition(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundRepeat(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

