/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.io.InvalidObjectException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormat
extends UFormat {
    static final long serialVersionUID = 1L;
    public final java.text.MessageFormat messageFormat;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_IN_QUOTE = 2;
    private static final int STATE_MSG_ELEMENT = 3;
    private String savedPattern;

    public MessageFormat(java.text.MessageFormat delegate) {
        this.wrapNestedFormatters(delegate);
        this.messageFormat = delegate;
    }

    public MessageFormat(String pattern) {
        this(new java.text.MessageFormat(pattern));
    }

    public MessageFormat(String pattern, Locale locale) {
        this(new java.text.MessageFormat(pattern, locale));
    }

    public MessageFormat(String pattern, ULocale locale) {
        this(new java.text.MessageFormat(pattern, locale.toLocale()));
    }

    public void setLocale(Locale locale) {
        this.messageFormat.setLocale(locale);
    }

    public void setLocale(ULocale locale) {
        this.messageFormat.setLocale(locale.toLocale());
    }

    public Locale getLocale() {
        return this.messageFormat.getLocale();
    }

    public ULocale getULocale() {
        return ULocale.forLocale(this.messageFormat.getLocale());
    }

    public void applyPattern(String pttrn) {
        this.messageFormat.applyPattern(pttrn);
        this.wrapNestedFormatters(this.messageFormat);
    }

    public String toPattern() {
        String pattern = this.savedPattern == null ? this.messageFormat.toPattern() : this.savedPattern;
        return pattern;
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        this.messageFormat.setFormatsByArgumentIndex(newFormats);
        this.savedPattern = null;
    }

    public void setFormatsByArgumentName(Map<String, Format> newFormats) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public void setFormats(Format[] newFormats) {
        this.messageFormat.setFormats(newFormats);
        this.savedPattern = null;
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        this.messageFormat.setFormatByArgumentIndex(argumentIndex, newFormat);
        this.savedPattern = null;
    }

    public void setFormatByArgumentName(String argumentName, Format newFormat) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        this.messageFormat.setFormat(formatElementIndex, newFormat);
        this.savedPattern = null;
    }

    public Format[] getFormatsByArgumentIndex() {
        return this.messageFormat.getFormatsByArgumentIndex();
    }

    public Format[] getFormats() {
        return this.messageFormat.getFormats();
    }

    public Set<String> getFormatArgumentNames() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public Format getFormatByArgumentName(String argumentName) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public final StringBuffer format(Object[] arguments, StringBuffer result, FieldPosition pos) {
        FieldPosition jdkPos = MessageFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.messageFormat.format(arguments, result, jdkPos);
        if (jdkPos != null) {
            pos.setBeginIndex(jdkPos.getBeginIndex());
            pos.setEndIndex(jdkPos.getEndIndex());
        }
        return buf;
    }

    public final StringBuffer format(Map<String, Object> arguments, StringBuffer result, FieldPosition pos) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static String format(String pattern, Object ... arguments) {
        return java.text.MessageFormat.format(pattern, arguments);
    }

    public static String format(String pattern, Map<String, Object> arguments) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public boolean usesNamedArguments() {
        return false;
    }

    @Override
    public final StringBuffer format(Object arguments, StringBuffer result, FieldPosition pos) {
        FieldPosition jdkPos = MessageFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.messageFormat.format(arguments, result, jdkPos);
        if (jdkPos != null) {
            pos.setBeginIndex(jdkPos.getBeginIndex());
            pos.setEndIndex(jdkPos.getEndIndex());
        }
        return buf;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object arguments) {
        AttributedCharacterIterator it = this.messageFormat.formatToCharacterIterator(arguments);
        StringBuilder sb = new StringBuilder();
        char c = it.first();
        while (c != '\uffff') {
            sb.append(c);
            c = it.next();
        }
        AttributedString attrstr = new AttributedString(sb.toString());
        int idx = 0;
        it.first();
        while (idx < it.getEndIndex()) {
            int end = it.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> attributes = it.getAttributes();
            if (attributes != null) {
                for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : attributes.entrySet()) {
                    AttributedCharacterIterator.Attribute attr = entry.getKey();
                    Object val = entry.getValue();
                    if (attr.equals(MessageFormat.Field.ARGUMENT)) {
                        attr = Field.ARGUMENT;
                        val = attr;
                    }
                    attrstr.addAttribute(attr, val, idx, end);
                }
            }
            idx = end;
            while (it.getIndex() < idx) {
                it.next();
            }
        }
        return attrstr.getIterator();
    }

    public Object[] parse(String source, ParsePosition pos) {
        return this.messageFormat.parse(source, pos);
    }

    public Map<String, Object> parseToMap(String source, ParsePosition pos) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public Object[] parse(String source) throws ParseException {
        return this.messageFormat.parse(source);
    }

    public Map<String, Object> parseToMap(String source) throws ParseException {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.messageFormat.parse(source, pos);
    }

    @Override
    public Object clone() {
        MessageFormat fmt = new MessageFormat((java.text.MessageFormat)this.messageFormat.clone());
        fmt.savedPattern = this.savedPattern;
        return fmt;
    }

    public boolean equals(Object obj) {
        try {
            return this.messageFormat.equals(((MessageFormat)obj).messageFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.messageFormat.hashCode();
    }

    public static String autoQuoteApostrophe(String pattern) {
        StringBuilder buf = new StringBuilder(pattern.length() * 2);
        int state = 0;
        int braceCount = 0;
        int i = 0;
        int j = pattern.length();
        while (i < j) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                            ++braceCount;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '{': {
                            ++braceCount;
                            break;
                        }
                        case '}': {
                            if (--braceCount != 0) break;
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
            ++i;
        }
        if (state == 1 || state == 2) {
            buf.append('\'');
        }
        return new String(buf);
    }

    private static FieldPosition toJDKFieldPosition(FieldPosition icuPos) {
        if (icuPos == null) {
            return null;
        }
        int fieldID = icuPos.getField();
        Format.Field fieldAttribute = icuPos.getFieldAttribute();
        FieldPosition jdkPos = null;
        if (fieldAttribute != null) {
            if (fieldAttribute.equals(Field.ARGUMENT)) {
                fieldAttribute = MessageFormat.Field.ARGUMENT;
            }
            jdkPos = new FieldPosition(fieldAttribute, fieldID);
        } else {
            jdkPos = new FieldPosition(fieldID);
        }
        jdkPos.setBeginIndex(icuPos.getBeginIndex());
        jdkPos.setEndIndex(icuPos.getEndIndex());
        return jdkPos;
    }

    private void wrapNestedFormatters(java.text.MessageFormat mfmt) {
        this.savedPattern = mfmt.toPattern();
        Format[] subfmts = mfmt.getFormats();
        int i = 0;
        while (i < subfmts.length) {
            if (subfmts[i] instanceof java.text.DateFormat) {
                subfmts[i] = new DateFormat((java.text.DateFormat)subfmts[i]);
            } else if (subfmts[i] instanceof java.text.NumberFormat) {
                subfmts[i] = new NumberFormat((java.text.NumberFormat)subfmts[i]);
            }
            ++i;
        }
        mfmt.setFormats(subfmts);
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7510380454602616157L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String name) {
            super(name);
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("A subclass of MessageFormat.Field must implement readResolve.");
            }
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("Unknown attribute name.");
        }
    }
}

