/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.session;

import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.platform.discovery.util.internal.session.ISessionFactory;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;
import org.eclipse.platform.discovery.util.internal.session.SessionManager;
import org.jmock.core.Constraint;

public class SessionManagerTests
extends MockObjectTestCase {
    protected ISessionManager<ISession<?>> target;
    private static final String[] sessionIds = new String[]{"session1id", "session2id"};
    private ISession<?>[] testSessions;
    private Mock<ISessionFactory<ISession<?>>> factoryMock;

    public void setUp() {
        this.factoryMock = this.mock(ISessionFactory.class);
        this.target = new SessionManager((ISessionFactory)this.factoryMock.proxy());
        this.testSessions = new ISession[sessionIds.length];
        int i = 0;
        while (i < this.testSessions.length) {
            this.expectCreationOfNewSession(sessionIds[i], 3);
            this.testSessions[i] = this.target.session(sessionIds[i], 3);
            ++i;
        }
    }

    public void testSessionWithNewId() {
        this.expectCreationOfNewSession("newSessionId", 1);
        ISession newSession = this.target.session("newSessionId", 1);
        SessionManagerTests.assertEquals((String)"newSessionId", (String)newSession.getId());
        SessionManagerTests.assertEquals((int)(this.testSessions.length + 1), (int)this.target.sessionCount());
    }

    public void testSessionWithExistingId() {
        ISession<?>[] iSessionArray = this.testSessions;
        int n = this.testSessions.length;
        int n2 = 0;
        while (n2 < n) {
            ISession<?> ts = iSessionArray[n2];
            SessionManagerTests.assertSame(ts, (Object)this.target.session(ts.getId(), 1));
            ++n2;
        }
    }

    public void expectCreationOfNewSession(String sessionId, int historySize) {
        this.factoryMock.expects(this.once()).method("newSession").with((Constraint)this.eq(sessionId), (Constraint)this.eq(historySize)).will(this.returnValue(this.newSessionStub(sessionId).proxy()));
    }

    public Mock<ISession<?>> newSessionStub(String sessionId) {
        Mock newSession = this.mock(ISession.class);
        newSession.stubs().method("getId").will(this.returnValue(sessionId));
        newSession.stubs().method("hashCode").will(this.returnValue(sessionId.hashCode()));
        return newSession;
    }
}

