/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.internal.view.EnablePropertiesForAllViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.impl.OpenPropsViewAction;

public class EnablePropertiesForAllViewCustomizationTest
extends TestCase {
    private IContributedAction action;
    private IResultsViewAccessor accessor;
    private ISelection selection;
    private EnablePropertiesForAllViewCustomization custUnderTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.selection = (ISelection)EasyMock.createMock(ISelection.class);
        this.custUnderTest = new EnablePropertiesForAllViewCustomization(){

            protected ISelection getSelection(IResultsViewAccessor accessor) {
                return EnablePropertiesForAllViewCustomizationTest.this.selection;
            }
        };
        this.accessor = (IResultsViewAccessor)EasyMock.createMock(IResultsViewAccessor.class);
    }

    public void testAcceptSearchProvider() {
        String[] stringArray = new String[3];
        stringArray[0] = "asd";
        stringArray[1] = "anything";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray2[n2];
            EnablePropertiesForAllViewCustomizationTest.assertTrue((boolean)this.custUnderTest.acceptSearchProvider(str));
            ++n2;
        }
    }

    public void testInstallAction() {
        EasyMock.expect((Object)this.selection.isEmpty()).andStubReturn((Object)false);
        IMenuManager mgr = (IMenuManager)EasyMock.createNiceMock(IMenuManager.class);
        EasyMock.expect((Object)this.accessor.getMenuManager()).andStubReturn((Object)mgr);
        EasyMock.expect((Object)mgr.find("z.org.eclipse.platform.discovery.ui.internal.view.openpropsview")).andReturn(null);
        mgr.add((IAction)EasyMock.isA(OpenPropsViewAction.class));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.accessor, this.selection, mgr});
        this.custUnderTest.installAction(this.action, this.accessor);
        EasyMock.reset((Object[])new Object[]{mgr});
        EasyMock.expect((Object)mgr.find("z.org.eclipse.platform.discovery.ui.internal.view.openpropsview")).andReturn((Object)((IContributionItem)EasyMock.createMock(IContributionItem.class)));
        EasyMock.replay((Object[])new Object[]{mgr});
        this.custUnderTest.installAction(this.action, this.accessor);
    }

    public void testInstallActionOnEmptySelection() {
        EasyMock.expect((Object)this.selection.isEmpty()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.accessor, this.selection});
        this.custUnderTest.installAction(this.action, this.accessor);
    }
}

