/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.impl.GenericViewCustomizationImpl;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcInteractionListener;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.LocalSelectionTransferSetter;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.XmlDiscoverySelectionTransferSetter;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.DiscoveryTreeViewerFactory;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DiscoveryTreeViewerFactoryTest
extends MockObjectTestCase {
    private Mock<IDoubleClickListener> dblClickListener;
    private DiscoveryTreeViewerFactory treeViewerFactory;
    private Mock<IDiscoveryEnvironment> environment;
    private IGenericViewCustomization viewCustomization;
    private Shell testShell;

    protected void setUp() throws Exception {
        this.dblClickListener = this.mock(IDoubleClickListener.class);
        this.testShell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.setupEnv();
        this.setupCustomization();
        this.treeViewerFactory = new DiscoveryTreeViewerFactory();
    }

    private void setupCustomization() {
        this.viewCustomization = new GenericViewCustomizationImpl(){

            public IDoubleClickListener getDoubleClickListener() {
                return (IDoubleClickListener)DiscoveryTreeViewerFactoryTest.this.dblClickListener.proxy();
            }
        };
    }

    private void setupEnv() {
        this.environment = this.mock(IDiscoveryEnvironment.class);
        this.environment.stubs().method("operationRunner").will(this.returnValue(this.mock(ILongOperationRunner.class).proxy()));
        this.environment.stubs().method("errorHandler").will(this.returnValue(this.mock(IErrorHandler.class).proxy()));
    }

    public void testDoubleClickOnTree() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        HashSet<IGenericViewCustomization> cust = new HashSet<IGenericViewCustomization>(Arrays.asList(this.viewCustomization));
        IResultsViewAccessor accessor = this.treeViewerFactory.createTreeViewer((Composite)this.testShell, cust, new HashSet(), (IDiscoveryEnvironment)this.environment.proxy());
        ListenerList list = this.getDoubleClickListeners((StructuredViewer)accessor.getTreeViewer());
        DiscoveryTreeViewerFactoryTest.assertTrue((String)"Double click listener not registered", (boolean)Arrays.asList(list.getListeners()).contains(this.dblClickListener.proxy()));
    }

    private ListenerList getDoubleClickListeners(StructuredViewer viewer) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = StructuredViewer.class.getDeclaredField("doubleClickListeners");
        f.setAccessible(true);
        return (ListenerList)f.get(viewer);
    }

    public void testSupportedTransferDataSetters() {
        final ArrayList setters = new ArrayList();
        this.treeViewerFactory = new DiscoveryTreeViewerFactory(){

            protected DragSrcInteractionListener.ITransferDataSetter<? extends Transfer>[] supportedTransferDataSetters(IDiscoveryEnvironment env) {
                DragSrcInteractionListener.ITransferDataSetter[] superSetters;
                DragSrcInteractionListener.ITransferDataSetter[] iTransferDataSetterArray = superSetters = super.supportedTransferDataSetters(env);
                int n = superSetters.length;
                int n2 = 0;
                while (n2 < n) {
                    DragSrcInteractionListener.ITransferDataSetter s = iTransferDataSetterArray[n2];
                    setters.add(s.getClass());
                    ++n2;
                }
                return superSetters;
            }
        };
        Shell parentShell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.treeViewerFactory.createTreeViewer((Composite)parentShell, new HashSet(), new HashSet(), (IDiscoveryEnvironment)this.environment.proxy());
        DiscoveryTreeViewerFactoryTest.assertEquals((String)"2 setters expected", (int)2, (int)setters.size());
        DiscoveryTreeViewerFactoryTest.assertTrue((String)"LocalSelectionTransferSetter not available", (boolean)setters.contains(LocalSelectionTransferSetter.class));
        DiscoveryTreeViewerFactoryTest.assertTrue((String)"XmlDiscoverySelectionTransferSetter not available", (boolean)setters.contains(XmlDiscoverySelectionTransferSetter.class));
    }
}

