/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IFormTextBuilder;
import org.eclipse.platform.discovery.ui.internal.tooltip.AbstractTooltipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.IToolTipConfigurator;

public class AbstractTooltipConfiguratorTest
extends MockObjectTestCase {
    protected Mock<IFormTextBuilder> textBuilder;
    private IToolTipConfigurator configurator;
    protected static final String TEXT_BUILDER_TEST_TEXT = "This is a test!";

    protected void setUp() throws Exception {
        this.textBuilder = this.mock(IFormTextBuilder.class);
        this.configurator = this.createConfigurator();
    }

    protected IToolTipConfigurator createConfigurator() {
        return new AbstractTooltipConfigurator(){

            protected void createContent(IFormTextBuilder tooltipBuilder) {
                AbstractTooltipConfiguratorTest.assertTrue((String)"Unexpected tooltip content", (boolean)tooltipBuilder.equals(AbstractTooltipConfiguratorTest.this.textBuilder.proxy()));
            }

            protected AbstractTooltipConfigurator.TooltipFormTextBuilder createNewTooltipTextBuilder() {
                return AbstractTooltipConfiguratorTest.this.createFormTextBuilderMock((IFormTextBuilder)AbstractTooltipConfiguratorTest.this.textBuilder.proxy());
            }
        };
    }

    public void testGetFormText() {
        AbstractTooltipConfiguratorTest.assertEquals((String)"Unexpected text", (String)TEXT_BUILDER_TEST_TEXT, (String)this.configurator.getFormText());
    }

    public void testGetTitleCaption() {
        AbstractTooltipConfiguratorTest.assertNull((String)"Title caption shoulkd be null in the abstract implementation", (Object)this.configurator.getTitleCaption());
    }

    public void testGetTitleImage() {
        AbstractTooltipConfiguratorTest.assertNull((String)"Title image shoulkd be null in the abstract implementation", (Object)this.configurator.getTitleImage());
    }

    protected AbstractTooltipConfigurator.TooltipFormTextBuilder createFormTextBuilderMock(final IFormTextBuilder delegate) {
        InvocationHandler invHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getText")) {
                    return AbstractTooltipConfiguratorTest.TEXT_BUILDER_TEST_TEXT;
                }
                Method delegationMethod = IFormTextBuilder.class.getMethod(method.getName(), method.getParameterTypes());
                return delegationMethod.invoke((Object)delegate, args);
            }
        };
        return (AbstractTooltipConfigurator.TooltipFormTextBuilder)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{AbstractTooltipConfigurator.TooltipFormTextBuilder.class}, invHandler);
    }
}

