/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot;

import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SashOrientation;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils.DndUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.hamcrest.SelfDescribing;

public class SWTBotSash
extends AbstractSWTBotControl<Sash> {
    private SWTBotSash(Sash sash) throws WidgetNotFoundException {
        super((Control)sash);
    }

    private SWTBotSash(Sash sash, SelfDescribing selfDescribing) {
        super((Control)sash, selfDescribing);
    }

    public static SWTBotSash sash(AbstractSWTBot<? extends Composite> parent, boolean shouldBeVisible) {
        return new SWTBotSash(new SwtBotUtils().findOneChildControlOfType(parent.widget, Sash.class, shouldBeVisible));
    }

    public SashOrientation getOrientation() {
        Rectangle bounds = this.getBounds();
        if (bounds.height < bounds.width) {
            return SashOrientation.HORIZONTAL;
        }
        return SashOrientation.VERTICAL;
    }

    private Rectangle getBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((Sash)SWTBotSash.this.widget).getBounds();
            }
        });
    }

    public void move(int offSet) {
        Point absoluteSashCenter = this.widgetCenterAbsolute();
        int targetX = this.getOrientation().equals((Object)SashOrientation.VERTICAL) ? absoluteSashCenter.x + offSet : absoluteSashCenter.x;
        int targetY = this.getOrientation().equals((Object)SashOrientation.VERTICAL) ? absoluteSashCenter.y : absoluteSashCenter.y + offSet;
        new DndUtil(this.display).dragAndDrop((AbstractSWTBot<? extends Widget>)this, new Point(targetX, targetY));
    }

    private Point widgetCenterAbsolute() {
        return this.widgetCenter(this.absoluteLocation());
    }

    private Point widgetCenterRelative() {
        return this.widgetCenter(this.getBounds());
    }

    private Point widgetCenter(Rectangle widgetlocation) {
        int x = widgetlocation.x + widgetlocation.width / 2;
        int y = widgetlocation.y + widgetlocation.height / 2;
        return new Point(x, y);
    }

    public int getOffset() {
        Point center = this.widgetCenterRelative();
        return this.getOrientation().equals((Object)SashOrientation.VERTICAL) ? Math.abs(center.x) : Math.abs(center.y);
    }
}

