/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractGalleryGroupRenderer {
    protected Gallery gallery;
    protected boolean expanded;

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean selected) {
        this.expanded = selected;
    }

    public void preDraw(GC gc) {
    }

    public abstract void draw(GC var1, GalleryItem var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void dispose();

    public abstract GalleryItem getNextItem(GalleryItem var1, int var2);

    public void preLayout(GC gc) {
    }

    public void postLayout(GC gc) {
    }

    public abstract void layout(GC var1, GalleryItem var2);

    public abstract GalleryItem getItem(GalleryItem var1, Point var2);

    public abstract Rectangle getSize(GalleryItem var1);

    public abstract boolean mouseDown(GalleryItem var1, MouseEvent var2, Point var3);

    public Gallery getGallery() {
        return this.gallery;
    }

    public void setGallery(Gallery gallery) {
        this.gallery = gallery;
    }

    protected Point getGroupSize(GalleryItem item) {
        return new Point(item.width, item.height);
    }

    protected Point getGroupPosition(GalleryItem item) {
        return new Point(item.x, item.y);
    }

    protected void setGroupSize(GalleryItem item, Point size) {
        item.width = size.x;
        item.height = size.y;
    }

    protected boolean isDebugMode() {
        return Gallery.DEBUG;
    }

    protected void notifyTreeListeners(GalleryItem group) {
        this.gallery.notifyTreeListeners(group, group.isExpanded());
    }

    protected void updateStructuralValues(boolean keeplocation) {
        this.gallery.updateStructuralValues(null, keeplocation);
    }

    protected void updateScrollBarsProperties() {
        this.gallery.updateScrollBarsProperties();
    }

    public int getScrollBarIncrement() {
        return 16;
    }
}

