/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.e4.xwt.IDataBindingInfo;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IValidationRule;
import org.eclipse.e4.xwt.IValueConverter;
import org.eclipse.e4.xwt.InverseValueConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.databinding.IBindingContext;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.validation.InverseValidationRule;

public class BindingGate {
    public static final UpdateSetStrategy POLICY_UPDATE = new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE);
    private final IBindingContext dataBindingContext;

    public BindingGate(IBindingContext dataBindingContext) {
        this.dataBindingContext = dataBindingContext;
    }

    public Binding bind(IObservableValue source, IObservableValue target) {
        return this.bind((IObservable)source, (IObservable)target, null);
    }

    public Binding bind(IObservable source, IObservable target, IDataBindingInfo dataBinding) {
        if (source instanceof IObservableValue && target instanceof IObservableValue) {
            return this.bindValue((IObservableValue)source, (IObservableValue)target, dataBinding);
        }
        if (source instanceof IObservableSet && target instanceof IObservableSet) {
            IValueConverter converter = null;
            int sourceToTargetPolicy = UpdateSetStrategy.POLICY_UPDATE;
            int targetToSourcePolicy = UpdateSetStrategy.POLICY_UPDATE;
            if (dataBinding != null) {
                switch (dataBinding.getMode()) {
                    case OneWay: {
                        targetToSourcePolicy = UpdateSetStrategy.POLICY_NEVER;
                        break;
                    }
                    case OneTime: {
                        sourceToTargetPolicy = UpdateSetStrategy.POLICY_NEVER;
                        targetToSourcePolicy = UpdateSetStrategy.POLICY_NEVER;
                        break;
                    }
                }
                converter = dataBinding.getConverter();
            }
            UpdateSetStrategy sourceToTarget = new UpdateSetStrategy(sourceToTargetPolicy);
            UpdateSetStrategy targetToSource = new UpdateSetStrategy(targetToSourcePolicy);
            return this.bindSet((IObservableSet)target, (IObservableSet)source, targetToSource, sourceToTarget, converter);
        }
        if (source instanceof IObservableList && target instanceof IObservableList) {
            IValueConverter converter = null;
            int sourceToTargetPolicy = UpdateListStrategy.POLICY_UPDATE;
            int targetToSourcePolicy = UpdateListStrategy.POLICY_UPDATE;
            if (dataBinding != null) {
                switch (dataBinding.getMode()) {
                    case OneWay: {
                        targetToSourcePolicy = UpdateListStrategy.POLICY_NEVER;
                        break;
                    }
                    case OneTime: {
                        sourceToTargetPolicy = UpdateListStrategy.POLICY_NEVER;
                        targetToSourcePolicy = UpdateListStrategy.POLICY_NEVER;
                        break;
                    }
                }
                converter = dataBinding.getConverter();
            }
            UpdateListStrategy sourceToTarget = new UpdateListStrategy(sourceToTargetPolicy);
            UpdateListStrategy targetToSource = new UpdateListStrategy(targetToSourcePolicy);
            return this.bindList((IObservableList)target, (IObservableList)source, targetToSource, sourceToTarget, converter);
        }
        throw new IllegalStateException();
    }

    public Binding bindList(IObservableList source, IObservableList target, UpdateListStrategy sourceToTarget, UpdateListStrategy targetToSource, IValueConverter converter) {
        if (converter != null) {
            return this.bindList(source, target, sourceToTarget, targetToSource, converter, new InverseValueConverter(converter));
        }
        return this.bindList(source, target, sourceToTarget, targetToSource, null, null);
    }

    public Binding bindList(IObservableList source, IObservableList target, UpdateListStrategy sourceToTarget, UpdateListStrategy targetToSource, IConverter sourceToTargetConvertor, IConverter targetToSourceConvertor) {
        if (source != null && target != null) {
            if (sourceToTarget == null) {
                sourceToTarget = new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE);
            }
            if (targetToSource == null) {
                targetToSource = new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE);
            }
            if (sourceToTargetConvertor != null) {
                sourceToTarget.setConverter(sourceToTargetConvertor);
            }
            if (targetToSourceConvertor != null) {
                targetToSource.setConverter(targetToSourceConvertor);
            }
            this.dataBindingContext.bindList(target, source, targetToSource, sourceToTarget);
        }
        return null;
    }

    public Binding bindSet(IObservableSet source, IObservableSet target, UpdateSetStrategy sourceToTarget, UpdateSetStrategy targetToSource, IValueConverter converter) {
        if (converter != null) {
            return this.bindSet(source, target, sourceToTarget, targetToSource, converter, new InverseValueConverter(converter));
        }
        return this.bindSet(source, target, sourceToTarget, targetToSource, null, null);
    }

    public Binding bindSet(IObservableSet source, IObservableSet target, UpdateSetStrategy sourceToTarget, UpdateSetStrategy targetToSource, IConverter sourceToTargetConvertor, IConverter targetToSourceConvertor) {
        if (source != null && target != null) {
            if (sourceToTarget == null) {
                sourceToTarget = new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE);
            }
            if (targetToSource == null) {
                targetToSource = new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE);
            }
            if (sourceToTargetConvertor != null) {
                sourceToTarget.setConverter(sourceToTargetConvertor);
            }
            if (targetToSourceConvertor != null) {
                targetToSource.setConverter(targetToSourceConvertor);
            }
            this.dataBindingContext.bindSet(target, source, targetToSource, sourceToTarget);
        }
        return null;
    }

    public Binding bind(IObservableList source, IObservableList target, UpdateListStrategy sourceToTarget, UpdateListStrategy targetToSource, IConverter sourceToTargetConvertor, IConverter targetToSourceConvertor) {
        if (source != null && target != null) {
            if (sourceToTarget == null) {
                sourceToTarget = new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE);
            }
            if (targetToSource == null) {
                targetToSource = new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE);
            }
            if (sourceToTargetConvertor != null) {
                sourceToTarget.setConverter(sourceToTargetConvertor);
            }
            if (targetToSourceConvertor != null) {
                targetToSource.setConverter(targetToSourceConvertor);
            }
            this.dataBindingContext.bindList(target, source, targetToSource, sourceToTarget);
        }
        return null;
    }

    private Binding bindValue(IObservableValue source, IObservableValue target, IDataBindingInfo dataBinding) {
        IValueConverter converter = null;
        IValidationRule[] validators = null;
        int sourceToTargetPolicy = UpdateValueStrategy.POLICY_UPDATE;
        int targetToSourcePolicy = UpdateValueStrategy.POLICY_UPDATE;
        if (dataBinding != null) {
            switch (dataBinding.getMode()) {
                case OneWay: {
                    targetToSourcePolicy = UpdateValueStrategy.POLICY_NEVER;
                    break;
                }
                case OneTime: {
                    sourceToTargetPolicy = UpdateValueStrategy.POLICY_NEVER;
                    targetToSourcePolicy = UpdateValueStrategy.POLICY_NEVER;
                    break;
                }
            }
            converter = dataBinding.getConverter();
            validators = dataBinding.getValidators();
        }
        UpdateValueStrategy sourceToTarget = new UpdateValueStrategy(sourceToTargetPolicy);
        UpdateValueStrategy targetToSource = new UpdateValueStrategy(targetToSourcePolicy);
        this.bindValidators(validators, sourceToTarget, targetToSource);
        return this.bind(source, target, sourceToTarget, targetToSource, converter);
    }

    private void bindValidators(IValidationRule[] validators, UpdateValueStrategy sourceToTarget, UpdateValueStrategy targetToSource) {
        if (validators != null) {
            IValidationRule[] iValidationRuleArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                IValidationRule validator = iValidationRuleArray[n2];
                switch (validator.getBindingMode()) {
                    case SourceToTarget: {
                        this.addValidatorToStrategy(sourceToTarget, validator);
                        break;
                    }
                    case TargetToSource: {
                        this.addValidatorToStrategy(targetToSource, new InverseValidationRule(validator));
                        break;
                    }
                    default: {
                        this.addValidatorToStrategy(sourceToTarget, validator);
                        this.addValidatorToStrategy(targetToSource, new InverseValidationRule(validator));
                    }
                }
                ++n2;
            }
        }
    }

    private void addValidatorToStrategy(UpdateValueStrategy strategy, IValidationRule validator) {
        switch (validator.getPhase()) {
            case AfterGet: {
                strategy.setAfterGetValidator((IValidator)validator);
                break;
            }
            case AfterConvert: {
                strategy.setAfterConvertValidator((IValidator)validator);
                break;
            }
            default: {
                strategy.setBeforeSetValidator((IValidator)validator);
            }
        }
    }

    public Binding bind(IObservableValue source, IObservableValue target, UpdateValueStrategy sourceToTarget, UpdateValueStrategy targetToSource, IValueConverter converter) {
        if (converter != null) {
            return this.bind(source, target, sourceToTarget, targetToSource, (IConverter)converter, (IConverter)new InverseValueConverter(converter));
        }
        return this.bind(source, target, sourceToTarget, targetToSource, null, null);
    }

    public Binding bind(IObservableValue source, IObservableValue target, UpdateValueStrategy sourceToTarget, UpdateValueStrategy targetToSource, IConverter sourceToTargetConvertor, IConverter targetToSourceConvertor) {
        if (source != null && target != null) {
            IDataProvider targetDataProvider;
            Class<Object> targetValueType;
            IDataProvider sourceDataProvider;
            Class<Object> sourceValueType;
            if (sourceToTarget == null) {
                sourceToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            }
            if (targetToSource == null) {
                targetToSource = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            }
            if ((sourceValueType = (sourceDataProvider = XWT.findDataProvider(source)).getDataType(null)) == null) {
                sourceValueType = Object.class;
            }
            if ((targetValueType = (targetDataProvider = XWT.findDataProvider(target)).getDataType(null)) == null) {
                targetValueType = Object.class;
            }
            Class sourceType = sourceValueType instanceof Class ? sourceValueType : sourceValueType.getClass();
            Class targetType = targetValueType instanceof Class ? targetValueType : targetValueType.getClass();
            sourceType = sourceType == null ? Object.class : ObjectUtil.normalizedType(sourceType);
            targetType = targetType == null ? Object.class : ObjectUtil.normalizedType(targetType);
            if (sourceToTarget.getUpdatePolicy() != UpdateValueStrategy.POLICY_NEVER) {
                IConverter m2t;
                if (sourceToTargetConvertor != null) {
                    sourceToTarget.setConverter(sourceToTargetConvertor);
                } else if (!targetType.isAssignableFrom(sourceType) && (m2t = XWT.findConvertor(sourceType, targetType)) != null) {
                    sourceToTarget.setConverter(m2t);
                }
            }
            if (targetToSource.getUpdatePolicy() != UpdateValueStrategy.POLICY_NEVER) {
                IConverter t2m;
                if (targetToSourceConvertor != null) {
                    targetToSource.setConverter(targetToSourceConvertor);
                } else if (!sourceType.isAssignableFrom(targetType) && (t2m = XWT.findConvertor(targetType, sourceType)) != null) {
                    targetToSource.setConverter(t2m);
                }
            }
            this.dataBindingContext.bindValue(target, source, targetToSource, sourceToTarget);
        }
        return null;
    }
}

