/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import java.lang.reflect.Array;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class ListToArrayObservableValue
extends AbstractObservableValue {
    protected IObservableList source;
    protected IObservableValue target;
    protected Object valueType;
    protected Object cacheData;

    public ListToArrayObservableValue(IObservableList source, IObservableValue target) {
        super(source.getRealm());
        this.source = source;
        this.target = target;
        source.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ListToArrayObservableValue.this.handleChange();
            }
        });
        source.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                ListToArrayObservableValue.this.dispose();
            }
        });
    }

    protected Object doGetValue() {
        return this.source;
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
    }

    public Object getValueType() {
        return this.source.getElementType();
    }

    public synchronized void dispose() {
        super.dispose();
        this.source.dispose();
        this.target.dispose();
        this.source = null;
        this.target = null;
    }

    protected void handleChange() {
        try {
            Object elements = Array.newInstance((Class)this.getValueType(), this.source.size());
            Object[] objects = this.source.toArray((Object[])elements);
            if (this.cacheData == null) {
                this.cacheData = this.target.getValue();
            }
            this.target.setValue((Object)objects);
            this.fireValueChange(Diffs.createValueDiff((Object)this.cacheData, (Object)objects));
            this.cacheData = objects;
        }
        catch (NegativeArraySizeException e) {
            e.printStackTrace();
        }
    }
}

