/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.core;

import java.lang.reflect.Method;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.annotation.Containment;
import org.eclipse.e4.xwt.core.TriggerAction;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.internal.core.IEventController;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.javabean.Controller;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.ModelUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class EventTrigger
extends TriggerBase {
    private String sourceName;
    private String routedEvent;
    private TriggerAction[] actions = TriggerAction.EMPTY_ARRAY;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getRoutedEvent() {
        return this.routedEvent;
    }

    public void setRoutedEvent(String routedEvent) {
        this.routedEvent = routedEvent;
    }

    @Containment
    public TriggerAction[] getActions() {
        return this.actions;
    }

    public void setActions(TriggerAction[] actions) {
        this.actions = actions;
    }

    public void prepare(Object target) {
        String routedEvent = this.getRoutedEvent();
        if (routedEvent != null) {
            Object source = EventTrigger.getElementByName(target, this.getSourceName());
            IMetaclass metaclass = XWT.getMetaclass(source);
            IEvent event = metaclass.findEvent(ModelUtils.normalizeEventName(routedEvent));
            if (event == null) {
                if (routedEvent != null && !routedEvent.toLowerCase().endsWith("event")) {
                    LoggerManager.log("Event " + routedEvent + " is not found in " + source.getClass().getName() + ". Please add a suffix \"Event\"!");
                } else {
                    LoggerManager.log("Event " + routedEvent + " is not found in " + source.getClass().getName());
                }
                return;
            }
            TriggerAction[] triggerActionArray = this.getActions();
            int n = triggerActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerAction triggerAction = triggerActionArray[n2];
                triggerAction.initialize(target);
                ++n2;
            }
            String name = event.getName();
            if ("loadedevent".equalsIgnoreCase(name)) {
                Widget widget = UserData.getWidget(source);
                IEventController eventController = UserData.updateEventController(source);
                RunablePaintAction paintRunnable = this.createPaintRunnable(source);
                try {
                    Method method = paintRunnable.getClass().getDeclaredMethod("run", Object.class, Event.class);
                    eventController.setEvent(event, widget, paintRunnable, this, method);
                }
                catch (Exception e) {
                    LoggerManager.log(e);
                }
            } else {
                RunableAction runnable = this.createRunnable(source);
                try {
                    runnable.setEventTrigger(event);
                }
                catch (Exception e) {
                    LoggerManager.log(e);
                }
            }
        }
    }

    public void on(Object target) {
    }

    protected RunableAction createRunnable(Object target) {
        return new RunableAction(target);
    }

    protected RunablePaintAction createPaintRunnable(Object target) {
        return new RunablePaintAction(target);
    }

    class RunableAction
    implements Listener,
    Runnable {
        protected Object target;
        private int count = 0;
        boolean started = false;
        boolean transition = false;
        private Event event;
        private int eventType;

        public RunableAction(Object target) {
            this.target = target;
        }

        public void run() {
            --this.count;
            if (this.count == 0 && !this.event.widget.isDisposed()) {
                final Display display = this.event.widget.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        if (RunableAction.this.transition) {
                            TriggerAction[] triggerActionArray = EventTrigger.this.getActions();
                            int n = triggerActionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TriggerAction triggerAction = triggerActionArray[n2];
                                triggerAction.initialize(RunableAction.this.target);
                                ++n2;
                            }
                        } else {
                            TriggerAction[] triggerActionArray = EventTrigger.this.getActions();
                            int n = triggerActionArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                TriggerAction triggerAction = triggerActionArray[n3];
                                triggerAction.endFinalize(RunableAction.this.target);
                                ++n3;
                            }
                        }
                        display.removeFilter(RunableAction.this.eventType, (Listener)RunableAction.this);
                        if (!((RunableAction)RunableAction.this).event.widget.isDisposed()) {
                            ((RunableAction)RunableAction.this).event.widget.notifyListeners(RunableAction.this.eventType, RunableAction.this.event);
                            display.addFilter(RunableAction.this.eventType, (Listener)RunableAction.this);
                        }
                        RunableAction.this.started = false;
                    }
                });
            }
        }

        protected void setEventTrigger(IEvent event) {
            Widget widget = UserData.getWidget(this.target);
            String name = event.getName();
            this.eventType = Controller.getEventTypeByName(name);
            if (this.eventType != 0) {
                widget.getDisplay().addFilter(this.eventType, (Listener)this);
                this.transition = this.eventType == XWTMaps.getEvent("swt.move") || this.eventType == XWTMaps.getEvent("swt.resize");
            }
        }

        public void handleEvent(Event event) {
            Widget widget = UserData.getWidget(this.target);
            if (event.widget != widget || widget.isDisposed()) {
                return;
            }
            if (this.started) {
                event.type = 0;
                return;
            }
            this.count = EventTrigger.this.getActions().length;
            this.started = true;
            try {
                TriggerAction triggerAction;
                int n;
                int n2;
                TriggerAction[] triggerActionArray;
                this.event = Controller.copy(event);
                if (!this.transition) {
                    triggerActionArray = EventTrigger.this.getActions();
                    n2 = triggerActionArray.length;
                    n = 0;
                    while (n < n2) {
                        triggerAction = triggerActionArray[n];
                        triggerAction.initialize(this.target);
                        ++n;
                    }
                }
                triggerActionArray = EventTrigger.this.getActions();
                n2 = triggerActionArray.length;
                n = 0;
                while (n < n2) {
                    triggerAction = triggerActionArray[n];
                    triggerAction.run(event, this.target, this);
                    ++n;
                }
            }
            catch (Exception exception) {
                this.started = false;
            }
            event.type = 0;
        }
    }

    class RunablePaintAction {
        protected Object target;

        public RunablePaintAction(Object target) {
            this.target = target;
        }

        public void run(Object object, Event event) {
            TriggerAction[] triggerActionArray = EventTrigger.this.getActions();
            int n = triggerActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerAction triggerAction = triggerActionArray[n2];
                triggerAction.run(event, this.target, null);
                ++n2;
            }
        }
    }
}

