/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.imagecapture.swt;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.swt.targetvm.unix.DisposeUtil;

public abstract class ImageCapture {
    static ImageCapture instance;

    public Image captureImage(Object control) {
        if (control instanceof Control) {
            Control ctl = (Control)control;
            return this.captureImage(ctl);
        }
        return null;
    }

    public Image captureImage(Control control) {
        Rectangle rectangle = control.getBounds();
        Display display = control.getDisplay();
        Image image = null;
        if (control instanceof Shell) {
            Shell shell = (Shell)control;
            shell.layout();
            Point parentLocation = control.toDisplay(0, 0);
            image = this.getImage(control, rectangle.width, rectangle.height, false);
            rectangle.x = parentLocation.x;
            rectangle.y = parentLocation.y;
            GC myImageGC = new GC((Drawable)image);
            try {
                Control[] controlArray = shell.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    Rectangle childBounds = child.getBounds();
                    int x = (rectangle.width - childBounds.width) / 2;
                    int y = rectangle.height - childBounds.height - x;
                    childBounds.x = rectangle.x + x;
                    childBounds.y = rectangle.y + y;
                    if (rectangle.intersects(childBounds)) {
                        Image childImage = new Image((Device)display, child.getBounds());
                        GC gc = new GC((Drawable)childImage);
                        child.print(gc);
                        DisposeUtil.dispose(gc);
                        try {
                            myImageGC.drawImage(childImage, x, y);
                        }
                        finally {
                            childImage.dispose();
                        }
                    }
                    ++n2;
                }
            }
            finally {
                myImageGC.dispose();
            }
        }
        image = this.capture(control);
        return image;
    }

    public Image capture(Control control) {
        Rectangle bounds = control.getBounds();
        return this.capture(control, bounds.width, bounds.height, false);
    }

    public Image capture(Control control, int width, int height, boolean includeChildren) {
        return this.getImage(control, width, height, includeChildren);
    }

    protected abstract Image getImage(Control var1, int var2, int var3, boolean var4);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageCapture getInstance() {
        if (instance != null) return instance;
        if ("win32".equals(Platform.getOS())) {
            instance = new org.eclipse.ve.internal.swt.targetvm.win32.ImageCapture();
            return instance;
        } else if ("gtk".equals(Platform.getWS())) {
            instance = "ia64".equals(Platform.getOSArch()) || "x86_64".equals(Platform.getOSArch()) ? new org.eclipse.ve.internal.swt.targetvm.unix.bits64.ImageCapture() : new org.eclipse.ve.internal.swt.targetvm.unix.ImageCapture();
            return instance;
        } else {
            if (!"macosx".equals(Platform.getOS())) throw new UnsupportedOperationException(Platform.getOS());
            if ("cocoa".equals(Platform.getWS())) {
                instance = new org.eclipse.ve.internal.swt.targetvm.macosx.cocoa.ImageCapture();
                return instance;
            } else {
                if (!"carbon".equals(Platform.getWS())) throw new UnsupportedOperationException(Platform.getOS());
                instance = new org.eclipse.ve.internal.swt.targetvm.macosx.ImageCapture();
            }
        }
        return instance;
    }

    public static int getIntHandle(Control control) {
        try {
            Field handleField = control.getClass().getField("handle");
            handleField.setAccessible(true);
            return (Integer)handleField.get(control);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return -1;
    }
}

