/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

class RefactorParticipantDelegate {
    RefactorParticipantDelegate() {
    }

    public static Change createChange(IProgressMonitor pm, final RefactoringParticipant p, String oldUrl, final String newUrl) throws CoreException, OperationCanceledException {
        String[] filenames = new String[]{"*.e4xmi"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])filenames, (boolean)false);
        Pattern pattern = Pattern.compile(oldUrl);
        final HashMap changes = new HashMap();
        TextSearchRequestor searchRequestor = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                IFile file = matchAccess.getFile();
                TextFileChange change = (TextFileChange)changes.get(file);
                if (change == null) {
                    TextChange textChange = p.getTextChange((Object)file);
                    if (textChange != null) {
                        return false;
                    }
                    change = new TextFileChange(file.getName(), file);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    changes.put(file, change);
                }
                ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), newUrl);
                change.addEdit((TextEdit)edit);
                change.addTextEditGroup(new TextEditGroup("Update contribution reference", (TextEdit)edit));
                return true;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)scope, searchRequestor, pattern, pm);
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange result = new CompositeChange("Update contribution reference");
        for (TextFileChange c : changes.values()) {
            result.add((Change)c);
        }
        return result;
    }
}

