/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import org.eclipse.e4.tm.graphics.util.Point;

public class PZoomEventHandler
extends PDragSequenceEventHandler {
    private double minScale = 0.0;
    private double maxScale = Double.MAX_VALUE;
    private Point viewZoomPoint;

    public PZoomEventHandler() {
        this.setEventFilter(new PInputEventFilter(0x200000));
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double minScale) {
        this.minScale = minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = maxScale;
    }

    protected void dragActivityFirstStep(PInputEvent aEvent) {
        this.viewZoomPoint = aEvent.getPosition();
        super.dragActivityFirstStep(aEvent);
    }

    protected void dragActivityStep(PInputEvent aEvent) {
        PCamera camera = aEvent.getCamera();
        double dx = aEvent.getCanvasPosition().getX() - this.getMousePressedCanvasPoint().getX();
        double scaleDelta = 1.0 + 0.001 * dx;
        double currentScale = camera.getViewScale();
        double newScale = currentScale * scaleDelta;
        if (newScale < this.minScale) {
            scaleDelta = this.minScale / currentScale;
        }
        if (this.maxScale > 0.0 && newScale > this.maxScale) {
            scaleDelta = this.maxScale / currentScale;
        }
        System.out.println("PZoomEventHandler: zoom " + scaleDelta);
        camera.scaleViewAboutPoint(scaleDelta, this.viewZoomPoint.getX(), this.viewZoomPoint.getY());
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("minScale=" + this.minScale);
        result.append(",maxScale=" + this.maxScale);
        result.append(",viewZoomPoint=" + (this.viewZoomPoint == null ? "null" : this.viewZoomPoint.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

