/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;

public class AutoConstructTest
extends TestCase {
    public void testCreatable() {
        IEclipseContext context = EclipseContextFactory.create();
        Consumer1 consumer1 = (Consumer1)ContextInjectionFactory.make(Consumer1.class, (IEclipseContext)context);
        AutoConstructTest.assertNotNull((Object)consumer1);
        boolean exception = false;
        try {
            ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)context);
        }
        catch (InjectionException injectionException) {
            exception = true;
        }
        AutoConstructTest.assertTrue((boolean)exception);
        context.set(Dependent2.class, (Object)new Dependent2());
        Consumer2 consumer2 = (Consumer2)ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)context);
        AutoConstructTest.assertNotNull((Object)consumer2);
    }

    static class Consumer1 {
        @Inject
        public Consumer1(Dependent1 dep) {
        }
    }

    static class Consumer2 {
        @Inject
        public Consumer2(Dependent2 dep) {
        }
    }

    @Creatable
    static class Dependent1 {
        @Inject
        public Dependent1() {
        }
    }

    static class Dependent2 {
        @Inject
        public Dependent2() {
        }
    }
}

