/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Provider;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Execute;

public class ProviderInjectionTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ProviderInjectionTest.class);
    }

    public ProviderInjectionTest() {
    }

    public ProviderInjectionTest(String name) {
        super(name);
    }

    public synchronized void testInvokeWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestInvokeClass userObject = new TestInvokeClass();
        ProviderInjectionTest.assertEquals((Object)1, (Object)ContextInjectionFactory.invoke((Object)userObject, Execute.class, (IEclipseContext)context, null));
        ProviderInjectionTest.assertNotNull((Object)userObject.provider.get());
        ProviderInjectionTest.assertEquals((String)"abc", (String)((TestData)userObject.provider.get()).data);
    }

    public synchronized void testConstructorWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestConstructorClass userObject = (TestConstructorClass)ContextInjectionFactory.make(TestConstructorClass.class, (IEclipseContext)context);
        ProviderInjectionTest.assertNotNull((Object)userObject);
        ProviderInjectionTest.assertNotNull(userObject.provider);
        ProviderInjectionTest.assertNotNull((Object)userObject.provider.get());
        ProviderInjectionTest.assertEquals((String)"abc", (String)((TestData)userObject.provider.get()).data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestConstructorClass {
        public Provider<TestData> provider;

        @Inject
        public TestConstructorClass(Provider<TestData> provider) {
            this.provider = provider;
        }
    }

    public static class TestData {
        public String data;

        @Inject
        public TestData(String tmp) {
            this.data = tmp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestInvokeClass {
        public Provider<TestData> provider;

        @Execute
        public int execute(Provider<TestData> arg) {
            this.provider = arg;
            return 1;
        }
    }
}

