/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.repository;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryFactory;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.datasource.WrappedDataSource;
import org.eclipse.dirigible.repository.ext.utils.EnvUtils;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class RepositoryFacade {
    private static final Logger logger = Logger.getLogger(RepositoryFacade.class);
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    public static final String REPOSITORY = "repository-instance";
    private static final String MASTER_REPOSITORY = "master-repository-instance";
    private static RepositoryFacade instance;
    private static DataSource localDataSource;
    private WrappedDataSource dataSource;

    private RepositoryFacade() {
    }

    public static RepositoryFacade getInstance() {
        if (instance == null) {
            instance = new RepositoryFacade();
        }
        return instance;
    }

    public IRepository getRepository() throws RepositoryException {
        return this.getRepository(null);
    }

    public IRepository getRepository(HttpServletRequest request) throws RepositoryException {
        IRepository repository = this.getRepositoryInstance(request);
        if (repository != null) {
            return repository;
        }
        try {
            DataSource defaultDataSource = DataSourceFacade.getInstance().getDataSource(request);
            String user = RepositoryFacade.getUser(request);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("datasource", defaultDataSource);
            parameters.put("user", user);
            parameters.put("recreate", Boolean.FALSE);
            parameters.put("masterRepositoryGitTarget", EnvUtils.getEnv((String)"masterRepositoryGitTarget"));
            parameters.put("masterRepositoryGitLocation", EnvUtils.getEnv((String)"masterRepositoryGitLocation"));
            parameters.put("masterRepositoryGitUser", EnvUtils.getEnv((String)"masterRepositoryGitUser"));
            parameters.put("masterRepositoryGitPassword", EnvUtils.getEnv((String)"masterRepositoryGitPassword"));
            parameters.put("masterRepositoryGitBranch", EnvUtils.getEnv((String)"masterRepositoryGitBranch"));
            parameters.put("localRepositoryRootFolder", EnvUtils.getEnv((String)"localRepositoryRootFolder"));
            parameters.put("localRepositoryRootFolderIsAbsolute", EnvUtils.getEnv((String)"localRepositoryRootFolderIsAbsolute"));
            parameters.put("localRepositoryRootFolderName", EnvUtils.getEnv((String)"localRepositoryRootFolderName", (String)"dirigible_local"));
            repository = RepositoryFactory.createRepository(parameters);
            this.saveRepositoryInstance(request, repository);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public IMasterRepository getMasterRepository(HttpServletRequest request) throws RepositoryException {
        IMasterRepository repository;
        block4: {
            repository = this.getMasterRepositoryInstance(request);
            if (repository != null) {
                return repository;
            }
            try {
                DataSource defaultDataSource = DataSourceFacade.getInstance().getDataSource(request);
                String user = RepositoryFacade.getUser(request);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("datasource", defaultDataSource);
                parameters.put("user", user);
                parameters.put("recreate", Boolean.FALSE);
                repository = RepositoryFactory.createMasterRepository(parameters);
                if (repository != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
        this.saveMasterRepositoryInstance(request, repository);
        return repository;
    }

    public static String getUser(HttpServletRequest request) {
        return RequestUtils.getUser((HttpServletRequest)request);
    }

    private IRepository getRepositoryInstance(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return (IRepository)request.getSession().getAttribute(REPOSITORY);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private IMasterRepository getMasterRepositoryInstance(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return (IMasterRepository)request.getSession().getAttribute(MASTER_REPOSITORY);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void saveRepositoryInstance(HttpServletRequest request, IRepository repository) {
        if (request == null) {
            return;
        }
        request.setAttribute(REPOSITORY, (Object)repository);
    }

    private void saveMasterRepositoryInstance(HttpServletRequest request, IMasterRepository repository) {
        if (request == null) {
            return;
        }
        request.setAttribute(MASTER_REPOSITORY, (Object)repository);
    }
}

