/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public abstract class AbstractRegistryServlet
extends HttpServlet {
    private static final long serialVersionUID = -9115022531455267478L;
    public static final String REPOSITORY_ATTRIBUTE = "repository-instance";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initRepository(request);
        super.service(request, response);
    }

    private IRepository initRepository(HttpServletRequest request) throws ServletException {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            if (request != null) {
                request.setAttribute(REPOSITORY_ATTRIBUTE, (Object)repository);
            }
            return repository;
        }
        catch (Exception ex) {
            throw new ServletException("Could not initialize Repository", (Throwable)ex);
        }
    }

    protected IRepository getRepository(HttpServletRequest request) throws IOException {
        IRepository repository = null;
        if (request != null) {
            repository = (IRepository)request.getAttribute(REPOSITORY_ATTRIBUTE);
        }
        if (repository == null) {
            try {
                repository = this.initRepository(request);
            }
            catch (Exception e) {
                this.log(e.getMessage(), e);
                throw new IOException(e);
            }
        }
        return repository;
    }

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath(request);
        return String.valueOf(this.getRepositoryPathPrefix(request)) + requestPath;
    }

    protected String getRepositoryPathPrefix(HttpServletRequest req) {
        return "/db/dirigible/registry/public";
    }

    protected IEntity getEntity(String repositoryPath, HttpServletRequest request) throws FileNotFoundException, IOException {
        IResource result = null;
        IRepository repository = this.getRepository(request);
        IResource resource = repository.getResource(repositoryPath);
        if (!resource.exists()) {
            ICollection collection = repository.getCollection(repositoryPath);
            if (collection.exists()) {
                result = collection;
            }
        } else {
            result = resource;
        }
        return result;
    }

    protected byte[] readResourceData(IResource resource) throws IOException {
        return resource.getContent();
    }

    protected void sendData(OutputStream out, byte[] data) throws IOException {
        out.write(data);
    }
}

