/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.transfer;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableDataReader;

public class DBTableImporter {
    private static final String DOT = ".";
    private static final String CLOSE = ")";
    private static final String VALUES = " VALUES (";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String Q = "?";
    private static final String COMMA = ",";
    private static final int BATCH_SIZE = 500;
    private byte[] csvFileContent;
    private String tableName;
    private DataSource dataSource;

    public DBTableImporter(DataSource dataSource, byte[] csvFileContent, String fileName) {
        this.csvFileContent = csvFileContent;
        this.tableName = this.getFileNameWithoutExtension(fileName);
        this.dataSource = dataSource;
    }

    public void insert() throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            List<String[]> records = DBTableDataReader.readRecords(new ByteArrayInputStream(this.csvFileContent));
            this.insertRecords(con, records, this.tableName);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private void insertRecords(Connection con, List<String[]> records, String tableName) throws SQLException {
        int columnsCount = records.get(0).length;
        PreparedStatement insertStat = con.prepareStatement(INSERT_INTO + tableName + VALUES + this.generateQM(columnsCount) + CLOSE);
        int recordsInBatch = 0;
        for (String[] record : records) {
            int i = 0;
            while (i < record.length) {
                insertStat.setString(i + 1, record[i]);
                ++i;
            }
            insertStat.addBatch();
            if (++recordsInBatch != 500) continue;
            insertStat.executeBatch();
            recordsInBatch = 0;
        }
        if (recordsInBatch != 0) {
            insertStat.executeBatch();
        }
    }

    private String generateQM(int number) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < number) {
            result.append(Q);
            if (i + 1 < number) {
                result.append(COMMA);
            }
            ++i;
        }
        return result.toString();
    }

    private String getFileNameWithoutExtension(String csvFileName) {
        return csvFileName.substring(0, csvFileName.lastIndexOf(DOT));
    }

    private void closeConnection(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    private Connection getConnection() throws Exception {
        Connection con = this.dataSource.getConnection();
        return con;
    }
}

