/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.ext.db.model.DependencyModel;
import org.eclipse.dirigible.repository.ext.db.model.EDataStructureModelFormatException;
import org.eclipse.dirigible.repository.ext.db.model.Messages;

public class DataStructureModel {
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_NAME = "name";
    private static final String DEPENDENCY_TYPE = "type";
    static final String ELEMENT_S_DOES_NOT_EXIST_IN_THIS_MODEL_S = Messages.DataStructureModel_ELEMENT_S_DOES_NOT_EXIST_IN_THIS_MODEL_S;
    static final String ELEMENT_S_MUST_BE_ARRAY_IN_THE_MODEL_S = Messages.DataStructureModel_ELEMENT_S_MUST_BE_ARRAY_IN_THE_MODEL_S;
    static final String ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_MODEL_S = Messages.DataStructureModel_ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_MODEL_S;
    private static final String ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCIES_ARRAY_IN_THE_TABLE_MODEL_S = Messages.DataStructureModel_ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCIES_ARRAY_IN_THE_TABLE_MODEL_S;
    private static final String ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S = Messages.DataStructureModel_ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S;
    private static final String ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S = Messages.DataStructureModel_ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S;
    private String name;
    private String type;
    private List<DependencyModel> dependencies = new ArrayList<DependencyModel>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<DependencyModel> getDependencies() {
        return this.dependencies;
    }

    protected void fillDependencies(JsonObject definitionObject) throws EDataStructureModelFormatException {
        JsonElement dependenciesElement = definitionObject.get(DEPENDENCIES);
        if (dependenciesElement == null) {
            return;
        }
        if (!dependenciesElement.isJsonArray()) {
            throw new EDataStructureModelFormatException(String.format(ELEMENT_S_MUST_BE_ARRAY_IN_THE_MODEL_S, DEPENDENCIES, this.getName()));
        }
        JsonArray dependenciesArray = dependenciesElement.getAsJsonArray();
        for (JsonElement jsonElement : dependenciesArray) {
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)jsonElement;
            JsonElement dependencyNameElement = jsonObject.get(DEPENDENCY_NAME);
            if (dependencyNameElement == null) {
                throw new EDataStructureModelFormatException(String.format(ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCIES_ARRAY_IN_THE_TABLE_MODEL_S, DEPENDENCY_NAME, this.getName()));
            }
            if (dependencyNameElement instanceof JsonArray) {
                throw new EDataStructureModelFormatException(String.format(ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_MODEL_S, DEPENDENCY_NAME, this.getName()));
            }
            String dependencyName = dependencyNameElement.getAsString();
            JsonElement dependencyTypeElement = jsonObject.get(DEPENDENCY_TYPE);
            if (dependencyTypeElement == null) {
                throw new EDataStructureModelFormatException(String.format(ELEMENT_S_DOES_NOT_EXIST_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S, DEPENDENCY_TYPE, dependencyName, this.getName()));
            }
            if (dependencyTypeElement instanceof JsonArray) {
                throw new EDataStructureModelFormatException(String.format(ELEMENT_S_MUST_BE_A_SINGLE_ELEMENT_NOT_AN_ARRAY_IN_THIS_DEPENDENCY_S_IN_THE_TABLE_MODEL_S, DEPENDENCY_TYPE, dependencyName, this.getName()));
            }
            String dependencyType = dependencyTypeElement.getAsString();
            DependencyModel dependencyModel = new DependencyModel(dependencyName, dependencyType);
            this.dependencies.add(dependencyModel);
        }
    }
}

