/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypeDiscriminator;
import org.eclipse.dirigible.ide.template.ui.common.service.AbstractGenerationWorker;
import org.eclipse.dirigible.ide.template.ui.db.service.DataStructureTemplateTypeDiscriminator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.ColumnDefinition;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateModel;
import org.eclipse.dirigible.repository.api.IRepository;

public class DatabaseGenerationWorker
extends AbstractGenerationWorker {
    private static final String PARAM_COLUMN_DEFAULT_VALUE = "defaultValue";
    private static final String PARAM_COLUMN_NOT_NULL = "notNull";
    private static final String PARAM_COLUMN_PRIMARY_KEY = "primaryKey";
    private static final String PARAM_COLUMN_LENGTH = "length";
    private static final String PARAM_COLUMN_TYPE = "type";
    private static final String PARAM_COLUMN_NAME = "name";
    private static final String PARAM_ROWS = "rows";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_COLUMNS = "columns";
    private static final DataStructureTemplateModel model = new DataStructureTemplateModel();
    private static final DataStructureTemplateGenerator generator = new DataStructureTemplateGenerator(model);
    private static final TemplateTypeDiscriminator typeDiscriminator = new DataStructureTemplateTypeDiscriminator();

    public DatabaseGenerationWorker(IRepository repository, IWorkspace workspace) {
        super(repository, workspace);
    }

    protected void readAndSetExtraParametersToModel(JsonObject parametersObject, GenerationModel model, TemplateType[] templates) throws GenerationException {
        DataStructureTemplateModel dbModel = (DataStructureTemplateModel)model;
        if (parametersObject.has(PARAM_COLUMNS)) {
            ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
            JsonArray columns = parametersObject.get(PARAM_COLUMNS).getAsJsonArray();
            for (JsonElement columnElement : columns) {
                if (!columnElement.isJsonObject()) continue;
                JsonObject columnObject = columnElement.getAsJsonObject();
                ColumnDefinition columnDefinition = new ColumnDefinition();
                columnDefinition.setName(columnObject.get(PARAM_COLUMN_NAME).getAsString());
                columnDefinition.setType(columnObject.get(PARAM_COLUMN_TYPE).getAsString());
                columnDefinition.setLength(columnObject.get(PARAM_COLUMN_LENGTH).getAsInt());
                columnDefinition.setPrimaryKey(columnObject.get(PARAM_COLUMN_PRIMARY_KEY).getAsBoolean());
                columnDefinition.setNotNull(columnObject.get(PARAM_COLUMN_NOT_NULL).getAsBoolean());
                columnDefinition.setDefaultValue(columnObject.get(PARAM_COLUMN_DEFAULT_VALUE).getAsString());
                columnDefinitions.add(columnDefinition);
            }
            dbModel.setColumnDefinitions(columnDefinitions.toArray(new ColumnDefinition[0]));
        } else {
            DatabaseGenerationWorker.checkIfRequired((GenerationModel)dbModel, (String)PARAM_COLUMNS);
        }
        if (parametersObject.has(PARAM_QUERY)) {
            dbModel.setQuery(parametersObject.get(PARAM_QUERY).getAsString());
        } else {
            DatabaseGenerationWorker.checkIfRequired((GenerationModel)dbModel, (String)PARAM_QUERY);
        }
        if (parametersObject.has(PARAM_ROWS)) {
            String rows;
            dbModel.setDsvSampleRows(rows.split((rows = parametersObject.get(PARAM_ROWS).getAsString()).indexOf("\n") >= 0 ? "\n" : "\r"));
        } else {
            DatabaseGenerationWorker.checkIfRequired((GenerationModel)dbModel, (String)PARAM_ROWS);
        }
    }

    protected GenerationModel getTemplateModel() {
        return model;
    }

    protected TemplateGenerator getTemplateGenerator() {
        return generator;
    }

    protected TemplateTypeDiscriminator getTypeDiscriminator() {
        return typeDiscriminator;
    }
}

