/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.template.ui.common.table.ContentForEntityModel;
import org.eclipse.dirigible.ide.template.ui.common.table.TableColumn;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class WizardForEntityTamplateTablePage
extends WizardPage {
    private static final String BTN_DESELECT_ALL = "&Deselect All";
    private static final String BTN_SELECT_ALL = "&Select All";
    private static final String COLUMN_LABEL = "Label";
    private static final String COLUMN_WIDGET = "Widget";
    private static final String COLUMN_SIZE = "Size";
    private static final String COLUMN_TYPE = "Type";
    private static final String COLUMN_NAME = "Name";
    private static final String ES_TABLE_TYPE = "tableType";
    private static final String ES_TABLE_NAME = "tableName";
    private static final String ES_DEPENDENT_COLUMN = "dependentColumn";
    private static final String DB_COLUMN_SIZE = "COLUMN_SIZE";
    private static final String DB_TYPE_NAME = "TYPE_NAME";
    private static final String DB_COLUMN_NAME = "COLUMN_NAME";
    private static final String ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION = "Error on Loading Table Columns from Database for Generation";
    private static final String AVAILABLE_FIELDS = "Available Fields";
    private static final Logger logger = Logger.getLogger(WizardForEntityTamplateTablePage.class);
    private TableViewer typeViewer;
    private ContentForEntityModel model;

    protected WizardForEntityTamplateTablePage(ContentForEntityModel model, String pageName) {
        super(pageName);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTableField(composite);
        this.checkPageStatus();
    }

    private void updateTableColumns() {
        TableColumn[] tableColumns = (TableColumn[])this.typeViewer.getInput();
        TableItem[] items = this.typeViewer.getTable().getItems();
        int selectionIndex = this.typeViewer.getTable().getSelectionIndex();
        int j = 0;
        while (j < items.length) {
            TableItem tblItem = items[j];
            this.typeViewer.getTable().setSelection(j);
            tableColumns[j].setVisible(tblItem.getChecked());
            if (tableColumns[j].isKey()) {
                items[this.typeViewer.getTable().getSelectionIndex()].setChecked(true);
                tableColumns[j].setVisible(true);
            }
            ++j;
        }
        this.typeViewer.getTable().setSelection(selectionIndex);
    }

    private boolean exists(List<TableColumn> availableTableColumns, TableColumn tableColumn) {
        for (TableColumn tableColumn2 : availableTableColumns) {
            TableColumn tableColumnX = tableColumn2;
            if (!tableColumnX.getName().equals(tableColumn.getName())) continue;
            return true;
        }
        return false;
    }

    private void checkPageStatus() {
        this.setPageComplete(this.model.validateTableColumns());
    }

    protected void parseEntityDescriptor() throws Exception {
        JsonElement dependentColumnElement;
        JsonElement tableTypeElement;
        JsonParser parser = new JsonParser();
        JsonObject entityService = (JsonObject)parser.parse((Reader)new InputStreamReader(this.model.getSourceFile().getContents(), ICommonConstants.UTF8));
        JsonElement tableNameElement = entityService.get(ES_TABLE_NAME);
        if (tableNameElement != null) {
            this.model.setTableName(tableNameElement.getAsString());
        }
        if ((tableTypeElement = entityService.get(ES_TABLE_TYPE)) != null) {
            this.model.setTableType(tableTypeElement.getAsString());
        }
        if ((dependentColumnElement = entityService.get(ES_DEPENDENT_COLUMN)) != null) {
            this.model.setDependentColumn(dependentColumnElement.getAsString());
        }
    }

    private void selectAll(boolean b) {
        TableColumn[] tableColumns = (TableColumn[])this.typeViewer.getInput();
        TableItem[] items = this.typeViewer.getTable().getItems();
        int selectionIndex = this.typeViewer.getTable().getSelectionIndex();
        int j = 0;
        while (j < items.length) {
            TableItem tblItem = items[j];
            this.typeViewer.getTable().setSelection(j);
            tableColumns[j].setVisible(tblItem.getChecked());
            items[this.typeViewer.getTable().getSelectionIndex()].setChecked(b || tableColumns[j].isKey());
            tableColumns[j].setVisible(true);
            ++j;
        }
        this.typeViewer.getTable().setSelection(selectionIndex);
    }

    private void createTableField(Composite parent) {
        Composite upperPart = new Composite(parent, 0);
        upperPart.setLayout((Layout)new GridLayout(3, false));
        upperPart.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(upperPart, 0);
        label.setText(AVAILABLE_FIELDS);
        label.setLayoutData((Object)new GridData(16384, 1024, true, false));
        Button selectButton = new Button(upperPart, 8);
        selectButton.setText(BTN_SELECT_ALL);
        selectButton.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        selectButton.setFont(JFaceResources.getDialogFont());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -7095187791495950403L;

            public void widgetSelected(SelectionEvent event) {
                WizardForEntityTamplateTablePage.this.selectAll(true);
            }
        });
        Button deselectButton = new Button(upperPart, 8);
        deselectButton.setText(BTN_DESELECT_ALL);
        deselectButton.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        deselectButton.setFont(JFaceResources.getDialogFont());
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 7117397741755265980L;

            public void widgetSelected(SelectionEvent event) {
                WizardForEntityTamplateTablePage.this.selectAll(false);
            }
        });
        this.typeViewer = new TableViewer(parent, 2596);
        Table table = this.typeViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn colName = new TableViewerColumn(this.typeViewer, 0);
        colName.getColumn().setWidth(200);
        colName.getColumn().setText(COLUMN_NAME);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableColumn column = (TableColumn)element;
                return column.getName();
            }
        });
        TableViewerColumn colType = new TableViewerColumn(this.typeViewer, 0);
        colType.getColumn().setWidth(100);
        colType.getColumn().setText(COLUMN_TYPE);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableColumn column = (TableColumn)element;
                return column.getType();
            }
        });
        TableViewerColumn colSize = new TableViewerColumn(this.typeViewer, 0);
        colSize.getColumn().setWidth(50);
        colSize.getColumn().setText(COLUMN_SIZE);
        colSize.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableColumn column = (TableColumn)element;
                return String.valueOf(column.getSize());
            }
        });
        TableViewerColumn colWidgetType = new TableViewerColumn(this.typeViewer, 0);
        colWidgetType.getColumn().setWidth(100);
        colWidgetType.getColumn().setText(COLUMN_WIDGET);
        colWidgetType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableColumn column = (TableColumn)element;
                return column.getWidgetType();
            }
        });
        WidgetTypeCellEditor widgetEditor = new WidgetTypeCellEditor(colWidgetType.getViewer());
        colWidgetType.setEditingSupport((EditingSupport)widgetEditor);
        this.typeViewer.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                WizardForEntityTamplateTablePage.this.typeViewer.refresh();
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }
        });
        TableViewerColumn colLabel = new TableViewerColumn(this.typeViewer, 0);
        colLabel.getColumn().setWidth(200);
        colLabel.getColumn().setText(COLUMN_LABEL);
        colLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableColumn column = (TableColumn)element;
                return String.valueOf(column.getSize());
            }
        });
        LabelCellEditor labelEditor = new LabelCellEditor(colLabel.getViewer());
        colLabel.setEditingSupport((EditingSupport)labelEditor);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider(this.getLabelProvider());
        this.createTableColumns();
        this.typeViewer.setInput((Object)this.model.getOriginalTableColumns());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WizardForEntityTamplateTablePage.this.updateTableColumns();
                WizardForEntityTamplateTablePage.this.checkPageStatus();
            }
        });
        this.updateTableColumns();
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    private void createTableColumns() {
        try {
            this.parseEntityDescriptor();
            Connection connection = this.getConnection();
            try {
                ArrayList<TableColumn> availableTableColumns = new ArrayList<TableColumn>();
                ResultSet primaryKeys = DBUtils.getPrimaryKeys((Connection)connection, (String)this.model.getTableName());
                ArrayList<String> primaryKeysList = new ArrayList<String>();
                while (primaryKeys.next()) {
                    String columnName = primaryKeys.getString(DB_COLUMN_NAME);
                    primaryKeysList.add(columnName);
                }
                ResultSet columns = DBUtils.getColumns((Connection)connection, (String)this.model.getTableName());
                while (columns.next()) {
                    String columnName = columns.getString(DB_COLUMN_NAME);
                    String columnType = columns.getString(DB_TYPE_NAME);
                    int columnSize = columns.getInt(DB_COLUMN_SIZE);
                    TableColumn tableColumn = null;
                    tableColumn = primaryKeysList.contains(columnName) ? new TableColumn(columnName, true, true, columnType, columnSize, "text", columnName) : new TableColumn(columnName, false, true, columnType, columnSize, "text", columnName);
                    if (this.exists(availableTableColumns, tableColumn)) continue;
                    availableTableColumns.add(tableColumn);
                }
                this.model.setTableColumns(availableTableColumns.toArray(new TableColumn[0]));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION, (Throwable)e);
        }
    }

    protected Connection getConnection() throws SQLException {
        try {
            return DataSourceFacade.getInstance().getDataSource(CommonIDEParameters.getRequest()).getConnection();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private final class LabelCellEditor
    extends EditingSupport {
        private TextCellEditor cellEditor;

        private LabelCellEditor(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = null;
            this.cellEditor = new TextCellEditor((Composite)this.getViewer().getControl(), 4);
        }

        protected void setValue(Object element, Object value) {
            TableColumn column;
            String newValue;
            if (element instanceof TableColumn && value instanceof String && !(newValue = (String)value).equals((column = (TableColumn)element).getLabel())) {
                column.setLabel(newValue);
            }
        }

        protected Object getValue(Object element) {
            if (element instanceof TableColumn) {
                TableColumn column = (TableColumn)element;
                return column.getLabel();
            }
            return null;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private final class WidgetTypeCellEditor
    extends EditingSupport {
        private ComboBoxViewerCellEditor cellEditor;

        private WidgetTypeCellEditor(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = null;
            this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.cellEditor.setContenProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.cellEditor.setInput((Object)new String[]{"text", "textarea", "date", "dropdown", "list", "integer", "float"});
        }

        protected void setValue(Object element, Object value) {
            TableColumn column;
            String newValue;
            if (element instanceof TableColumn && value instanceof String && !(newValue = (String)value).equals((column = (TableColumn)element).getWidgetType())) {
                column.setWidgetType(newValue);
            }
        }

        protected Object getValue(Object element) {
            if (element instanceof TableColumn) {
                TableColumn column = (TableColumn)element;
                return column.getWidgetType();
            }
            return null;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

