/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.dirigible.ide.db.viewer.views.IDatabaseConnectionFactory;
import org.eclipse.dirigible.ide.db.viewer.views.TableDefinition;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.dirigible.ide.db.viewer.views.actions.Messages;
import org.eclipse.dirigible.ide.db.viewer.views.actions.RefreshViewAction;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class DeleteViewAction
extends Action {
    private static final Logger logger = Logger.getLogger(DeleteViewAction.class);
    private static final String DROP_VIEW = "DROP VIEW ";
    private static final String DATABASE_VIEW = Messages.DeleteTableAction_DATABASE_VIEW;
    private static final String FAILED_TO_DELETE_TABLE_S = Messages.DeleteTableAction_FAILED_TO_DELETE_TABLE_S;
    private static final String WARNING_THIS_ACTION_WILL_DELETE_THE_VIEW_CONTINUE = Messages.DeleteTableAction_WARNING_THIS_ACTION_WILL_DELETE_THE_VIEW_CONTINUE;
    private static final String WILL_DELETE_THE_VIEW = Messages.DeleteTableAction_WILL_DELETE_THE_VIEW;
    private static final String DELETE_VIEW = Messages.DeleteTableAction_DELETE_VIEW;
    private static final long serialVersionUID = 3872859942737870851L;
    private TreeViewer viewer;

    public DeleteViewAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(DELETE_VIEW);
        this.setToolTipText(WILL_DELETE_THE_VIEW);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TreeParent parent = null;
        for (Object obj : selection) {
            if (!TreeObject.class.isInstance(obj) || ((TreeObject)obj).getTableDefinition() == null) continue;
            TableDefinition tableDefinition = ((TreeObject)obj).getTableDefinition();
            boolean confirm = MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)DELETE_VIEW, (String)String.format(WARNING_THIS_ACTION_WILL_DELETE_THE_VIEW_CONTINUE, tableDefinition.getTableName()));
            if (!confirm) continue;
            parent = ((TreeObject)obj).getParent();
            IDatabaseConnectionFactory connectionFactory = parent.getConnectionFactory();
            try {
                this.deleteView(tableDefinition, connectionFactory);
            }
            catch (SQLException e) {
                this.showMessage(String.valueOf(String.format(FAILED_TO_DELETE_TABLE_S, tableDefinition.getTableName())) + "\n\n" + e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (parent != null) {
            RefreshViewAction refresh = new RefreshViewAction(this.viewer, parent.getChildren()[0]);
            refresh.run();
        }
    }

    protected void showMessage(String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)DATABASE_VIEW, (String)message);
    }

    private void deleteView(TableDefinition tableDefinition, IDatabaseConnectionFactory connectionFactory) throws SQLException {
        Connection connection = connectionFactory.getDatabaseConnection();
        try {
            Statement dropStatement = connection.createStatement();
            try {
                String name = tableDefinition.getFqn();
                dropStatement.execute(DROP_VIEW + name);
            }
            finally {
                if (dropStatement != null) {
                    dropStatement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

